@extends('dashboard.body.main')

@section('container')
<form method="POST" action="{{route('storeprice.item.update',[$storeprice->storeid,$storeprice->productid])}}">
<div class="container-fluid">
     <div class="row">
            <div class="col-lg-12">
                @if (session()->has('success'))
                    <div class="alert text-white bg-success" role="alert">
                        <div class="iq-alert-text">{{ session('success') }}</div>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <i class="ri-close-line"></i>
                        </button>
                    </div>
                @endif
                <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                    <div>
                        <h4 class="mb-3"> Item Price List - {{$store->name}} </h4>
                    </div>
                    <div>
                        <ul class="list-inline">
                            <li class="list-inline-item">

                                    @csrf
                                    <button type="submit" class="btn"> <i class="fa-solid fa-save mr-3"></i> Save </button>

                            </li>
                            <li class="list-inline-item">
                                <a href="{{ route('order.index') }}" class="btn  add-list"><i class="fa-solid fa-trash mr-3"></i>Cancel</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
     </div>




    <div class="row">


                        <div class="row">
                            <div class="form-group col-md-8">
                                <div class="form-floating mb-3 ">
                                    <input type="text" class="form-control" id="Description"   placeholder="Product Code" value="{{$product->product_code}}">
                                    <label for="buying_price">Product<span class="text-danger">*</span></label>
                                </div>
                                @error('buying_price')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-4">
                                <div class="form-floating mb-3 ">
                                    <input type="text" class="form-control" id="price"  name="price" placeholder="Unit Code" value="{{$storeprice->price}}" required/>
                                    <label for="buying_price">Price per {{$unit->Code}} in TZS<span class="text-danger">*</span></label>
                                </div>
                                @error('buying_price')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                        </div>




        </div>




</form>
@endsection
