<?php $__env->startSection('specificpagestyles'); ?>
    <script src="https://code.jquery.com/jquery-3.3.1.min.js"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('container'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <div class="header-title">
                        <h4 class="card-title">Edit Role in Permission</h4>
                    </div>
                </div>

                <div class="card-body">
                    <form action="<?php echo e(route('rolePermission.update', $role->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('put'); ?>
                        <!-- begin: Input Data -->
                        <div class=" row align-items-center mb-2">
                            <div class="form-group col-md-6">
                                <label for="role_id">Role Name</label>
                                <h4><?php echo e($role->name); ?></h4>
                                
                            </div>
                        </div>

                        <div class="row align-items-center">
                            <div class="form-group col-md-6">
                                <label for="name">Permission Name <span class="text-danger">*</span></label>
                            </div>
                        </div>


                        <div class="row">
                            <div class="form-group col-md-3">
                                <div class="custom-control custom-checkbox custom-control-inline">
                                    <input type="checkbox" class="custom-control-input" id="check-all">
                                    <label class="custom-control-label" for="check-all">Check All</label>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <?php $__currentLoopData = $permission_groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission_group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $permissions = App\Models\User::getPermissionByGroupName($permission_group->group_name);
                        ?>

                        <div class="row">
                            <div class="form-group col-md-3">
                                <div class="custom-control custom-checkbox custom-control-inline">
                                    <input
                                        type="checkbox"
                                        class="custom-control-input"
                                        id="permission_group_id[<?php echo e($loop->iteration); ?>]"
                                        name="permission_group_id[]"
                                        <?php echo e(App\Models\User::roleHasPermission($role, $permissions) ? 'checked' : ''); ?>

                                    >
                                    <label
                                        for="permission_group_id[<?php echo e($loop->iteration); ?>]"
                                        class="custom-control-label"
                                    >
                                        <?php echo e($permission_group->group_name); ?>

                                    </label>
                                </div>
                            </div>

                            <div class="form-group col-md-6">
                                <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="custom-control custom-checkbox custom-control-inline my-2">
                                        <input
                                            type="checkbox"
                                            class="custom-control-input"
                                            id="permission_id[<?php echo e($permission->id); ?>]"
                                            name="permission_id[]"
                                            value="<?php echo e($permission->id); ?>"
                                            <?php echo e($role->hasPermissionTo($permission->name) ? 'checked' : ''); ?>

                                        >
                                        <label
                                            for="permission_id[<?php echo e($permission->id); ?>]"
                                            class="custom-control-label"
                                        >
                                            <?php echo e($permission->name); ?>

                                        </label>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <hr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <!-- end: Input Data -->
                        <div class="mt-2">
                            <button type="submit" class="btn btn-primary mr-2">Save</button>
                            <a class="btn bg-danger" href="<?php echo e(route('rolePermission.index')); ?>">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Page end  -->
</div>

<script>
    $('#check-all').click(function() {
        if($(this).is(':checked')) {
            $('input[type = checkbox]').prop('checked', true);
        } else {
            $('input[type = checkbox]').prop('checked', false);
        }
    });
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.body.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/smaryqic/rories-apps.co.tz/n4/resources/views/roles/role-permission-edit.blade.php ENDPATH**/ ?>