<?php $__env->startSection('container'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            <?php if(session()->has('success')): ?>
                <div class="alert text-white bg-success" role="alert">
                    <div class="iq-alert-text"><?php echo e(session('success')); ?></div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            <?php endif; ?>
            <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                <div>
                    <h4 class="mb-3">Advance Salary List</h4>
                    <p class="mb-0">A advance salary dashboard lets you easily gather and visualize advance salary data from optimizing <br>
                        the advance salary experience, ensuring advance salary retention. </p>
                </div>
                <div>
                <a href="<?php echo e(route('advance-salary.create')); ?>" class="btn btn-primary add-list"><i class="fas fa-plus mr-3"></i></i>Create Advance Salary</a>
                <a href="<?php echo e(route('advance-salary.index')); ?>" class="btn btn-danger add-list"><i class="fa-solid fa-trash mr-3"></i>Clear Search</a>
                </div>
            </div>
        </div>

        <div class="col-lg-12">
            <form action="<?php echo e(route('advance-salary.index')); ?>" method="get">
                <div class="d-flex flex-wrap align-items-center justify-content-between">
                    <div class="form-group row">
                        <label for="row" class="col-sm-3 align-self-center">Row:</label>
                        <div class="col-sm-9">
                            <select class="form-control" name="row">
                                <option value="10" <?php if(request('row') == '10'): ?>selected="selected"<?php endif; ?>>10</option>
                                <option value="25" <?php if(request('row') == '25'): ?>selected="selected"<?php endif; ?>>25</option>
                                <option value="50" <?php if(request('row') == '50'): ?>selected="selected"<?php endif; ?>>50</option>
                                <option value="100" <?php if(request('row') == '100'): ?>selected="selected"<?php endif; ?>>100</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="control-label col-sm-3 align-self-center" for="search">Search:</label>
                        <div class="col-sm-8">
                            <div class="input-group">
                                <input type="text" id="search" class="form-control" name="search" placeholder="Search employee" value="<?php echo e(request('search')); ?>">
                                <div class="input-group-append">
                                    <button type="submit" class="input-group-text bg-primary"><i class="fa-solid fa-magnifying-glass font-size-20"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <div class="col-lg-12">
            <div class="table-responsive rounded mb-3">
                <table class="table mb-0">
                    <thead class="bg-white text-uppercase">
                        <tr class="ligth ligth-data">
                            <th>No.</th>
                            <th>Photo</th>
                            <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('employee.name', 'name'));?></th>
                            <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('date'));?></th>
                            <th><?php echo \Kyslik\ColumnSortable\SortableLink::render(array ('advance_salary', 'advance salary'));?></th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody class="ligth-body">
                        <?php $__empty_1 = true; $__currentLoopData = $advance_salaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $advance_salary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e((($advance_salaries->currentPage() * 10) - 10) + $loop->iteration); ?></td>
                            <td>
                                <img class="avatar-60 rounded" src="<?php echo e($advance_salary->employee->photo ? asset('storage/employees/'.$advance_salary->employee->photo) : asset('assets/images/user/1.png')); ?>">
                            </td>
                            <td><?php echo e($advance_salary->employee->name); ?></td>
                            <td><?php echo e(Carbon\Carbon::parse($advance_salary->date)->format('M/Y')); ?></td>
                            <td><?php echo e($advance_salary->advance_salary ? '$'.$advance_salary->advance_salary : 'No Advance'); ?></td>
                            <td>
                                <form action="<?php echo e(route('advance-salary.destroy', $advance_salary->id)); ?>" method="POST" style="margin-bottom: 5px">
                                    <?php echo method_field('delete'); ?>
                                    <?php echo csrf_field(); ?>
                                    <div class="d-flex align-items-center list-action">
                                        <a class="btn btn-success mr-2" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit"
                                            href="<?php echo e(route('advance-salary.edit', $advance_salary->id)); ?>""><i class="ri-pencil-line mr-0"></i>
                                        </a>
                                        <button type="submit" class="btn btn-warning mr-2 border-none" onclick="return confirm('Are you sure you want to delete this record?')" data-toggle="tooltip" data-placement="top" title="" data-original-title="Delete">
                                            <i class="ri-delete-bin-line mr-0"></i>
                                        </button>
                                    </div>
                                </form>
                            </td>
                        </tr>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="alert text-white bg-danger" role="alert">
                            <div class="iq-alert-text">Data not Found.</div>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <i class="ri-close-line"></i>
                            </button>
                        </div>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php echo e($advance_salaries->links()); ?>

        </div>
    </div>
    <!-- Page end  -->
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.body.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rories/Downloads/laravel-point-of-sale-main/resources/views/advance-salary/index.blade.php ENDPATH**/ ?>