<?php $__env->startSection('container'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            <?php if(session()->has('success')): ?>
                <div class="alert text-white bg-success" role="alert">
                    <div class="iq-alert-text"><?php echo e(session('success')); ?></div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            <?php endif; ?>
            <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                <div>
                    <h4 class="mb-3">Purchase Order Receive</h4>

                </div>
                <div>
                    <a href="<?php echo e(route('order.create')); ?>" class="btn btn-primary add-list"><i class="fa-solid fa-plus mr-3"></i>Add PO</a>
                    <a href="<?php echo e(route('order.index')); ?>" class="btn btn-danger add-list"><i class="fa-solid fa-trash mr-3"></i>Clear Search</a>
                </div>
            </div>
        </div>

        <div class="col-lg-12">
            <form action="<?php echo e(route('suppliers.index')); ?>" method="get">
                <div class="d-flex flex-wrap align-items-center justify-content-between">
                    <div class="form-group row">
                        <label for="row" class="col-sm-3 align-self-center">Row:</label>
                        <div class="col-sm-9">
                            <select class="form-control" name="row">
                                <option value="10" <?php if(request('row') == '10'): ?>selected="selected"<?php endif; ?>>10</option>
                                <option value="25" <?php if(request('row') == '25'): ?>selected="selected"<?php endif; ?>>25</option>
                                <option value="50" <?php if(request('row') == '50'): ?>selected="selected"<?php endif; ?>>50</option>
                                <option value="100" <?php if(request('row') == '100'): ?>selected="selected"<?php endif; ?>>100</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="control-label col-sm-3 align-self-center" for="search">Search:</label>
                        <div class="col-sm-8">
                            <div class="input-group">
                                <input type="text" id="search" class="form-control" name="search" placeholder="Search Order" value="<?php echo e(request('search')); ?>">
                                <div class="input-group-append">
                                    <button type="submit" class="input-group-text bg-primary"><i class="fa-solid fa-magnifying-glass font-size-20"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <div class="col-lg-12">
            <div class="table-responsive rounded mb-3">
                <table class="table mb-0">
                    <thead class="bg-white text-uppercase">
                        <tr class="ligth ligth-data">
                            <th>Order No.</th>
                            <th>Suppliers</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody class="ligth-body">
                                    <?php $__currentLoopData = $orderSuppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderSupplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="text-align-left"><?php echo e($orderSupplier->ControlNum); ?></td>
                                            <td><?php echo e($orderSupplier->name); ?></td>

                                            <td>
                                                <form method="POST" action="<?php echo e(route('purchase.receive.ItemsLists',$orderSupplier->ControlNum)); ?>">
                                                    <?php echo csrf_field(); ?>
                                                <button type="submit">Select</button>
                                                </form>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <!---     -->
        </div>
    </div>
    <!-- Page end  -->
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.body.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/smaryqic/rories-apps.co.tz/n4/resources/views/purchase/receive/index.blade.php ENDPATH**/ ?>