<?php $__env->startSection('container'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            <?php if(session()->has('success')): ?>
                <div class="alert text-white bg-success" role="alert">
                    <div class="iq-alert-text"><?php echo e(session('success')); ?></div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            <?php endif; ?>
            <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                <div>
                    <h4 class="mb-3">Role List</h4>
                    <p class="mb-0">A role dashboard lets you easily gather and visualize role data from optimizing <br>
                        the role experience, ensuring role retention. </p>
                </div>
                <div>
                    <a href="<?php echo e(route('role.create')); ?>" class="btn btn-primary add-list"><i class="fa-solid fa-plus mr-3"></i>Add Role</a>
                </div>
            </div>
        </div>

        

        <div class="col-lg-12">
            <div class="table-responsive rounded mb-3">
                <table class="table mb-0">
                    <thead class="bg-white text-uppercase">
                        <tr class="ligth ligth-data">
                            <th>No.</th>
                            <th>Role Name</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody class="ligth-body">
                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e((($roles->currentPage() * 10) - 10) + $loop->iteration); ?></td>
                            <td><?php echo e($role->name); ?></td>
                            <td>
                                <form action="<?php echo e(route('role.destroy', $role->id)); ?>" method="POST" style="margin-bottom: 5px">
                                    <?php echo method_field('delete'); ?>
                                    <?php echo csrf_field(); ?>
                                    <div class="d-flex align-items-center list-action">
                                        <a class="btn btn-success mr-2" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit"
                                            href="<?php echo e(route('role.edit', $role->id)); ?>""><i class="ri-pencil-line mr-0"></i>
                                        </a>
                                        <button type="submit" class="btn btn-warning mr-2 border-none" onclick="return confirm('Are you sure you want to delete this record?')" data-toggle="tooltip" data-placement="top" title="" data-original-title="Delete"><i class="ri-delete-bin-line mr-0"></i></button>
                                    </div>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <?php echo e($roles->links()); ?>

        </div>
    </div>
    <!-- Page end  -->
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.body.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/smaryqic/rories-apps.co.tz/n4/resources/views/roles/role-index.blade.php ENDPATH**/ ?>