<?php

use App\Http\Controllers\Purchases\PurchaseOrder;
use App\Http\Controllers\Purchases\Requisation;
use App\Http\Controllers\Purchases\poReceive;





Route::middleware('auth')->group(function(){


    Route::resource('/order', PurchaseOrder::class);
    Route::resource('/requisation', Requisation::class);
    
    Route::get('/order/create/{ControlNum}/list', [PurchaseOrder::class,'create_new'])->name('order.create.list');
    
    Route::POST('/supplier/{POCtrlNum}', [PurchaseOrder::class,'SupplierList'])->name('order.Supplier');
    Route::POST('/create_new/{POCtrlNum}', [PurchaseOrder::class,'create_new'])->name('order.Supplier')->name('order.create.new');
    
    //Route::POST('/supplier/{Supplier}/{POCtrlNum}', [PurchaseOrder::class,'SupplierListAssign'])->name('order.supplier.assign');
    
    Route::POST('/supplier/{Supplier}/{POCtrlNum}/{applydate}/{Currency}', [PurchaseOrder::class,'SupplierListAssign'])->name('order.supplier.assign');
    
    Route::GET('/order/{POCtrlNum}/Items', [PurchaseOrder::class,'OrderItemList'])->name('order.supplier.items');
    
    Route::POST('/order/{POCtrlNum}/Items/name', [PurchaseOrder::class,'OrderItemListByName'])->name('order.supplier.items.name');
    
    
    Route::POST('/order/item/{POCtrlNum}/{Item}/select', [PurchaseOrder::class,'OrderItemSelect'])->name('order.item.select');
    Route::POST('/order/{POCtrlNum}/{Item}/store', [PurchaseOrder::class,'OrderItemStore'])->name('order.supplier.item.store');
    
    Route::DELETE('/order/{POCtrlNum}/cancel', [PurchaseOrder::class,'OrderItemCancel'])->name('order.items.cancel');
    
    Route::POST('/order/{POCtrlNum}', [PurchaseOrder::class,'complete'])->name('purchase.order.complete');
    
    
    
    
    
    
    
    Route::GET('/receive', [poReceive::class,'index'])->name('purchase.receive.index');
    Route::POST('/receive/{POCtrlNum}/lists', [poReceive::class,'ItemsLists'])->name('purchase.receive.ItemsLists');
    
    Route::GET('/receive/{POCtrlNum}/lists', [poReceive::class,'ItemsLists'])->name('purchase.receive.ItemsLists');
    
    
    
    Route::POST('/receive/{POCtrlNum}/{Item}', [poReceive::class,'Item'])->name('purchase.receive.Items');
    
    Route::POST('/receive/save/{POCtrlNum}/{Item}', [poReceive::class,'save'])->name('purchase.receive.save');

});