<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\inventory\home;
use App\Http\Controllers\inventory\adjustment;

Route::middleware('auth')->group(
    function(){
        Route::MATCH(['POST','GET'],'products/{productid}',[home::class,'product'])->name('inventory.home');
        Route::POST('products/{productid}/adjustment',[home::class,'adjustment'])->name('inventory.adjustment');
        Route::POST('products/{productid}/adjustment/save',[home::class,'save'])->name('inventory.adjustment.save');
         Route::MATCH(['POST','GET'],'products/{productid}/history',[home::class,'history'])->name('inventory.history');
         
         
         
         


        Route::MATCH(['POST','GET'],'index',[adjustment::class,'index'])->name('inventory.index');
        Route::MATCH(['GET','POST'],'store/products/{store}',[adjustment::class,'products'])->name('inventory.products');
        Route::POST('store/product/{store}/{product}',[adjustment::class,'product'])->name('inventory.product');
        Route::POST('save/{store}/{product}',[adjustment::class,'save'])->name('inventory.save');         
         
    }
);
