@extends('dashboard.body.main')

@section('container')
<div class="container-fluid">
    <form method="POST" action="{{route('itemunit.store')}}">
        @csrf
        <div class="col-lg-12">
            @if (session()->has('success'))
                <div class="alert text-white bg-success" role="alert">
                    <div class="iq-alert-text">{{ session('success') }}</div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            @endif
            <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                <div>
                    <h4 class="mb-3">Item Unit Create</h4>

                </div>
                <div>
                    <button type="submit" class="btn btn add-list"><i class="fa-solid fa-plus mr-3"></i>Save</button>
                    <a href="{{ route('itemunit.index') }}" class="btn add-list"><i class="fa-solid fa-trash mr-3"></i>Cancel</a>
                </div>
            </div>
        </div>



        <div class="row">


                        <div class="row">
                            <div class="form-group col-md-4">
                                <div class="form-floating mb-3 ">
                                    <input type="text" class="form-control" id="Code"  name="Code" placeholder="Unit Code" required/>
                                    <label for="buying_price">Unit Code<span class="text-danger">*</span></label>
                                </div>
                                @error('buying_price')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-8">
                                <div class="form-floating mb-3 ">
                                    <input type="text" class="form-control" id="Description"  name="Description" placeholder="Unit Description" required/>
                                    <label for="buying_price">Unit Description<span class="text-danger">*</span></label>
                                </div>
                                @error('buying_price')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                        </div>

        </div>
    </form>
    <!-- Page end  -->
</div>

@endsection





















