@extends('dashboard.body.main')

@section('container')
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            @if (session()->has('success'))
                <div class="alert text-white bg-success" role="alert">
                    <div class="iq-alert-text">{{ session('success') }}</div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            @endif
            @if (session()->has('error'))
                <div class="alert text-white bg-danger" role="alert">
                    <div class="iq-alert-text">{{ session('success') }}</div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            @endif
            <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                <div>
                    <h4 class="mb-3">Stores List</h4>

                </div>
                <div>
                    <!--
                    <a href="{{ route('products.importView') }}" class="btn btn-success add-list">Import</a>
                    <a href="{{ route('products.exportData') }}" class="btn btn-warning add-list">Export</a>
                    -->
                    <!-- <a href="{{ route('products.create') }}" class="btn btn-primary add-list">Add Product</a> -->
                    <form method="POST" action="{{route('users.index')}}">
                        @csrf
                        @method('GET')
                        <button class="btn">cancel</button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-12">
            <div class="table-responsive rounded mb-3">
                <table class="table mb-0">
                    <thead class="bg-white text-uppercase">
                        <tr class="ligth ligth-data">
                            <th>Name</th>
                            <th>Code</th>
                            <th>Address</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody class="ligth-body">
                        @forelse ($stores as $store)
                        <tr>

                            <td>{{ $store->address1 }}</td>
                            <td>{{ $store->name }}</td>
                            <td>{{ $store->phone1 }}</td>
                            <td>
                                <ul class="list-inline">
                                    <li class="list-inline-item">
                                        <form action="{{route('user.store.update',[$store->id,$userid])}}" method="POST" style="margin-bottom: 5px">
                                            @method('POST')
                                            @csrf
                                            <button type="submit" class="btn  mr-2 border-none"  data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit"><i class="fa-solid fa-box-open mr-0"></i>View</button>
                                        </form>
                                    </li>
                                </ul>
                            </td>
                        </tr>

                        @empty
                        <div class="alert text-white bg-danger" role="alert">
                            <div class="iq-alert-text">Data not Found.</div>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <i class="ri-close-line"></i>
                            </button>
                        </div>
                        @endforelse
                    </tbody>
                </table>
            </div>
            {{ $stores->links() }}
        </div>
    </div>
    <!-- Page end  -->
</div>

@endsection
