@extends('dashboard.body.main')

@section('container')
    <div class="container-fluid">
        <div class="row">






            <div class="col-6">

                <div class="row mb-1">

                    <div class="col-4">
                            <button type="submit" class="col-12 btn-default btn-block p-3"  data-toggle="modal" data-target="#exampleModal" data-whatever="0">Calculator</button>
                    </div>


                    <div class="col-4">
                        <form method="POST" action="{{route('sales.item.complete',$ControlNum)}}">
                            @csrf
                            <button type="button" name="completebtn" id="completebtn" class="col-12 btn-default btn-block p-3" onclick="submitSalesData()">Complete</button>
                        </form>
                    </div>

                    <div class="col-4">
                        <form method="GET" action="{{route('sales.index')}}">
                            <button type="submit" class="col-12 btn-default btn-block p-3">Cancel</button>
                        </form>
                    </div>

                </div>


                <div class="row">
                         <div class="mb-1 row">
                                <div class="col-6 row">
                                    <span class="col-6">Customer  </span>
                                    <select class="col-6 text-end" id="customer" value="0.00" readonly/>
                                        <option value="0">Cash</iption>
                                        @foreach($Customers as $Customer)
                                            <option value="{{$Customer->id}}">{{$Customer->name}}</iption>
                                        @endforeach
                                    </select>
                                 </div>
                                <div class="col-6 row" style="bgcolor:blue">
                                    <span class="col-6">Pay Mode </span>
                                    <span class="col-6">

                                        <!--
                                        <div class="form-check form-switch">
                                          <input class="form-check-input" type="checkbox" id="paymentMode" name="paymentMode" >
                                          <label class="form-check-label" for="paymentMode">Cash</label>
                                        </div>
                                        -->
                                        <select  class="col-12" id="paymentMode" >
                                            @foreach($paymentModes as $paymentMode)
                                                <option value="{{$paymentMode->id}}">{{$paymentMode->Code}}</option>
                                            @endforeach
                                        </select>

                                    </span>

                                </div>
                        </div>

                        <div class="mb-1 row">
                                <div class="col-6 row">
                                    <span class="col-6">Gross Total  </span>
                                    <input type="text" class="col-6 text-end" id="displaygross" value="0.00" readonly/>
                                    <input type="hidden" class="col-6 text-end" id="gross" value="0.00" readonly/>
                                 </div>
                                <div class="col-6 row" style="bgcolor:blue">
                                    <span class="col-6">Tax </span>
                                    <input type="text" class="col-6 text-end" id="tax" name="tax" value="0.00" readonly/>
                                </div>
                        </div>
                        <div class="mb-1 row">
                                <div class="col-6 row">
                                    <span class="col-6">Discount </span>
                                    <input type="text" class="col-6 text-end"  id="discount" name="discount" value="0.00">
                                </div>
                                <div class="col-6 row">
                                    <span class="col-6">Total </span>
                                    <input type="text" class="col-6 text-end" id="grandtotal" value="0.00" readonly/>
                                 </div>

                        </div>
                    <!--
                        <div class="mb-1 row">
                                 <div class="col-6 row">
                                    <span class="col-6">Amt Paid </span>
                                    <input type="text" class="col-6 text-end" id="amtPaid" name="amtPaid" value="0">
                                </div>
                                <div class="col-6 row">
                                    <span class="col-6">Balance </span>
                                    <input type="text"  class="col-6 text-end" id="balance"  name="balance" value="0.00" readonly/>
                                </div>
                        </div>
                    -->
                </div>
<!--
<div id="loadingSpinner" style="display: none;">
    <div class="spinner-border text-primary" role="status">
        <span class="visually-hidden">Loading...</span>
    </div>
    <span>Processing...</span>
</div>
-->


                <div class="row">









                    <table id="salesTable" class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Item Name</th>
                                <th>Price</th>
                                <th>Quantity</th>
                                <th>Total</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="tableBody">
                            <!-- Data will be appended here -->
                        </tbody>
                    <!--
                        <tfoot>
                            <tr>
                                <td colspan="3" class="text-end"><strong>Grand Total:</strong></td>
                                <td id="grandTotal">0.00</td>
                                <td></td>
                            </tr>
                        </tfoot>
                    -->
                    </table>








                </div>
             </div>












            <div class="col-1">&nbsp;</div>
            <div class="col-5">

                    <div class="row" id="searchItems">
                            <div class="input-group mb-3">
                                <input type="text" id="searchValue" name="searchValue" class="form-control" placeholder="Scan bar code" aria-label="Scan bar code" aria-describedby="basic-addon2">
                                <!--
                                Search result span has been added to autoload the result from a text
                                -->
                                <span id="searchResult" name="searchResult"></span>
                                <div class="input-group-append">
                                  <ul>
                                       <li>
                                          <div class="form-check">
                                                  <input type="radio" class="form-check-input" id="mode" name="mode" value="1" checked >Barcode
                                                  <label class="form-check-label" for="radio1"></label>
                                          </div>
                                        </li>
                                        <li>
                                          <div class="form-check">
                                                  <input type="radio" class="form-check-input" id="mode" name="mode" value="2" >Description
                                                  <label class="form-check-label" for="radio2"></label>
                                          </div>
                                        </li>
                                    </ul>
                                </div>

                            </div>
                    </div>


                    <div class="row" id="searchresult">

                    </div>
                    <div class="row" id="EntryForm">

                            <form data-action="{{ route('sales.item.save',$ControlNum) }}" method="POST" enctype="multipart/form-data" id="SalesItem">
                                @csrf
                                <div class="form-floating mb-3">
                                  <input type="text" class="form-control" id="itemname"  name="itemname" placeholder="Item name">

                                  <label for="floatingInput">Item name</label>
                                </div>
                                <div class="form-floating mb-3">
                                  <input type="text" class="form-control" id="price"  name="price" placeholder="Item Price">
                                  <label for="floatingPassword">Item Price</label>
                                </div>
                                <div class="form-floating mb-3">
                                  <input type="text" class="form-control" id="taxname"  name="taxname" placeholder="Tax">
                                  <label for="floatingPassword">Tax</label>
                                </div>
                                <div class="form-floating mb-3">
                                  <input type="text" class="form-control" id="quantity"  name="quantity" placeholder="Quantity">
                                  <label for="floatingPassword">Quantity</label>
                                </div>


                                <div class="form-floating mb-3">
                                    <button type="button" class="btn btn-secondary" name="btnSave" id="btnSave">Save</button>
                                </div>


                                  <input type="hidden" class="form-control" id="taxctrlnum"  name="taxctrlnum" placeholder="Tax">
                                  <input type="hidden" class="form-control" id="itemctrlnum"  name="itemctrlnum" placeholder="Item name">

                                  <input type="hidden" class="form-control" id="OrderCtrlNum"  name="OrderCtrlNum" value="{{$ControlNum}}" />
                            </form>
                    </div>


            </div>
        </div>
    </div>




<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Mini Calculator</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form>
          <div class="form-group">
            <label for="recipient-name" class="col-form-label">Amount Paid:</label>
            <input type="text" class="form-control" id="CapturedAmount">
          </div>
          <div class="form-group">
            <label for="recipient-name" class="col-form-label">Balance:</label>
            <input type="text" class="form-control" id="BalanceAmount" readonly/>
          </div>
        </form>
      </div>

    </div>
  </div>
</div>







@endsection


@section('specificpagescripts');

<script>

    const   mode = document.querySelector('input[name="mode"]:checked');
    var selectedValue = document.querySelector('input[name="mode"]:checked').value;
    const   searchValue = document.getElementById("searchValue");




    document.addEventListener('change', function(event) {
        if (event.target.name === 'mode' && event.target.checked) {
            if (event.target.value == 1) {
                $('#searchValue').attr('placeholder','Scan BarCode');
                //$('#searchresult').hide();
                //$('#EntryForm').show();
            }
            if(event.target.value == 2){
                $('#searchValue').attr('placeholder','Enter Item Description');
                //$('#searchresult').show();
                //$('#EntryForm').hide();
                //getItemslists();
            }
        }
    });






    searchValue.addEventListener('input',function(){
        if (document.querySelector('input[name="mode"]:checked').value == 1){
            ItemDetailsByBarCode(this.value);
        }
        if (document.querySelector('input[name="mode"]:checked').value == 2){
            const searchTerm = this.value.trim();
            if (searchTerm.length > 2) { // Only search after 3 characters
                loadProducts(searchTerm);
            } else {
                clearDropdown();
            }
        }
    });


    ItemDetailsByBarCode = function(varBarCode){

            var url = "{{ route('sales.item', ":varBarCode") }}";
            url = url.replace(':varBarCode', varBarCode);
            $.ajax({
                type: 'GET',
                url: url,
                //data: formData,
                dataType: 'json',
                success: function(response) {

                    //alert(response.product_name);
                    setItemetails(response,varBarCode);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        //$("#btnSave").focus();
    }


    setItemetails = function(result,varBarCode){
        $("#searchValue").val(varBarCode);
        $("#itemname").val(result.product_name);
        $("#price").val(result.selling_price);
        //$("#taxname").val(result.tax_id);
        $("#quantity").val("1");
        //$("#taxctrlnum").val(result.tax_id);
        $("#itemctrlnum").val(result.id);
        $("#taxctrlnum").val(result.tax_id);
        $("#taxname").val(result.name);
    }

    /* Search by description */
    // Function to clear dropdown
    function clearDropdown() {
        searchResult.innerHTML = '';
    }











function loadProducts(searchTerm) {


     var url = "{{ route('sales.item.description', ":searchTerm") }}";
     url = url.replace(':searchTerm', searchTerm);



    // Clear previous results immediately for better UX
    clearDropdown();

    // Validate input
    if (!searchTerm || searchTerm.trim().length < 3) {
        return;
    }

    // Show loading indicator
    if (searchResult) {
        searchResult.innerHTML = '<div class="dropdown-item text-muted">Searching...</div>';
    }

    $.ajax({
        type: 'GET',
        url: url,
        //data: {
        //    q: searchTerm.trim(),
            // You can add other parameters if needed
            // limit: 10,
            // category: 'some_category'
        //},
        dataType: 'json',
        timeout: 10000, // 10 second timeout
        success: function(response) {
            // Handle different response formats
            const products = Array.isArray(response) ? response :
                           response.data ? response.data :
                           response.products ? response.products : [];

            displayDropdown(products);
        },
        error: function(xhr, status, error) {
            console.error('Error searching products:', error);

            // Clear loading indicator
            clearDropdown();

            // Show error message to user
            if (searchResult) {
                let errorMessage = 'Error searching products';

                if (xhr.status === 404) {
                    errorMessage = 'Search endpoint not found';
                } else if (xhr.status === 500) {
                    errorMessage = 'Server error occurred';
                } else if (status === 'timeout') {
                    errorMessage = 'Request timed out';
                }

                searchResult.innerHTML = `<div class="dropdown-item text-danger">${errorMessage}</div>`;

                // Auto-hide error after 3 seconds
                setTimeout(() => {
                    clearDropdown();
                }, 3000);
            }
        },
        complete: function() {
            // This runs regardless of success/error
            // Remove loading indicator if still showing
            if (searchResult && searchResult.innerHTML.includes('Searching...')) {
                // Loading indicator will be replaced by results or error message
            }
        }
    });
}









    function displayDropdown(products) {


        console.log(products);
        clearDropdown();

        if (products.length === 0) {
            searchResult.innerHTML = '<div class="dropdown-item text-muted">No products found</div>';
            return;
        }

        const dropdown = document.createElement('div');
        dropdown.className = 'dropdown-menu show';
        dropdown.style.cssText = 'position: absolute; width: 100%; max-height: 200px; overflow-y: auto;';

        products.forEach(product => {
            const item = document.createElement('a');
            item.className = 'dropdown-item';
            item.href = '#';
            item.innerHTML = `
                <strong>${product.product_code}</strong>
                <small class="text-muted"> - ${product.barcode}</small>
                <br>
                <small>Price: TZS ${product.selling_price}</small>
            `;

            item.addEventListener('click', function(e) {
                e.preventDefault();
                selectProduct(product);
            });

            dropdown.appendChild(item);
        });

        searchResult.appendChild(dropdown);
    }


    function selectProduct(product) {
        // Clear the search input
        searchValue.value = '';

        // Clear the dropdown
        clearDropdown();

        // Call ItemDetailsByBarCode with the product's barcode
        if (product.barcode) {
            ItemDetailsByBarCode(product.barcode);
        } else if (product.code) {
            // If no barcode field, use code as fallback
            ItemDetailsByBarCode(product.code);
        } else {
            console.error('Product has no barcode or code field');
            // Optionally, you can populate form fields directly from the product object
            setItemDetailsFromProduct(product);
        }
    }


    $('#btnSave').on('click', function() {
        appendToSalesTable()
    });





















// XSS protection function
function escapeHtml(unsafe) {
    if (unsafe === null || unsafe === undefined) return '';
    return unsafe.toString()
        .replace(/&/g, "&amp;")
        .replace(/</g, "&lt;")
        .replace(/>/g, "&gt;")
        .replace(/"/g, "&quot;")
        .replace(/'/g, "&#039;");
}

function appendToSalesTable() {
    const tableBody = document.getElementById('tableBody');

    // Convert to numbers and get values
    const itemname = $('#itemname').val();
    const price = parseFloat($('#price').val()) || 0; // Convert to number
    const quantity = parseInt($('#quantity').val()) || 1; // Convert to number, default to 1
    const total = price * quantity;


    const itemctrlnum = $('#itemctrlnum').val();
    const taxctrlnum = $('#taxctrlnum').val();



    // Validate inputs
    if (!itemname) {
        alert('Please enter an item name');
        return;
    }

    if (price <= 0) {
        alert('Please enter a valid price');
        return;
    }

    // Create new row
    const newRow = document.createElement('tr');

    let formatted = total.toLocaleString(undefined, {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
    });<!-- Format to 2 decimal places -->



    newRow.innerHTML = `
        <td >${escapeHtml(itemname)}</td> <!-- Use escapeHtml for safety -->
        <td class="price">${price.toFixed(2)}</td> <!-- Format to 2 decimal places -->
        <td>
            <input type="number" class="form-control quantity-input" value="${quantity}" min="1" data-price="${price}" style="width: 80px;">
        </td>

        <td class="displaytotal">${formatted}</td>
        <td class="total" style="display:none">${total.toFixed(2)}</td> <!-- Format to 2 decimal places -->
        <td>
            <button class="btn btn-danger btn-sm remove-btn">Remove</button>
        </td>

        <td class="itemctrlnum" style="display: none;">${itemctrlnum}</td> <!-- Use escapeHtml for safety -->
        <td class="taxctrlnum" style="display: none;">${taxctrlnum}</td> <!-- Use escapeHtml for safety -->
    `;

    // Add event listener for quantity change
    const quantityInput = newRow.querySelector('.quantity-input');
    quantityInput.addEventListener('change', function() {
        updateRowTotal(this);
    });

    // Add event listener for remove button
    const removeBtn = newRow.querySelector('.remove-btn');
    removeBtn.addEventListener('click', function() {
        if (confirm('Are you sure you want to remove this item?')) {
            newRow.remove();
            updateGrandTotal();
        }
    });

    // Append row to table
    tableBody.appendChild(newRow);

    // Update grand total
    updateGrandTotal();

    // Clear form fields after adding to table
    clearFormFields();
}

// Add this missing function for quantity updates
function updateRowTotal(inputElement) {
    const row = inputElement.closest('tr');
    const price = parseFloat(inputElement.getAttribute('data-price'));
    const quantity = parseInt(inputElement.value) || 1;
    const total = price * quantity;

    row.querySelector('.total').textContent = total.toFixed(2);
    row.querySelector('.displaytotal').textContent = total.toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2});<!-- Format to 2 decimal places -->


    updateGrandTotal();
}

function updateGrandTotal() {
    const totalCells = document.querySelectorAll('#tableBody .total');
    let grandTotal = 0;

    totalCells.forEach(cell => {
        grandTotal += parseFloat(cell.textContent) || 0;
    });
    $('#gross').val(grandTotal.toFixed(2));



    displayGTotal = grandTotal.toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2});
    $('#displaygross').val(displayGTotal);
    //$('#grandTotal').text(grandTotal.toFixed(2));
}

function clearFormFields() {
    $('#itemname').val('');
    $('#price').val('');
    $('#quantity').val('1');
    $('#itemctrlnum').val('');
    $('#taxctrlnum').val('');
    $('#taxname').val('');
    $('#searchValue').val('').focus();
}




async function submitSalesData() {
    const submitBtn = $('#completebtn');

    // Show loading state
    showButtonLoading(submitBtn, 'Processing...');
    submitBtn.prop('disabled', true);

    const salesDetails = prepareSalesData();
    if (!salesDetails) {
        hideButtonLoading(submitBtn);
        return;
    }

    const salesHeader = {
        control_num: $('#OrderCtrlNum').val(),
        customer_id: $('#customer').val(),
        payment_mode: $('#paymentMode').val(),
        gross_total: parseFloat($('#gross').val()) || 0,
        tax_total: parseFloat($('#tax').val()) || 0,
        discount: parseFloat($('#discount').val()) || 0,
        grand_total: parseFloat($('#grandtotal').val()) || 0
    };

    // Prepare complete data object
    const salesData = {
        ...salesHeader,
        sales_items: salesDetails  // Changed to sales_items to match backend validation
    };

    console.log('Sending data:', salesData);

    try {
        const response = await $.ajax({
            url: '{{ route("sales.complete") }}',
            type: 'POST',
            contentType: 'application/json',
            dataType: 'json',
            data: JSON.stringify(salesData),
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        if (response.success) {
            showSuccessMessage(response.message || 'Sales data saved successfully!');

            // Optional: Redirect or clear form
            setTimeout(() => {
                const controlNum = $('#OrderCtrlNum').val();
                window.location.href = '{{ route("sales.print", ":id") }}'.replace(':id', controlNum);
            }, 2000);




           // window.open('route("sales.print",$('#OrderCtrlNum').val())', 'name');


        } else {
            throw new Error(response.message || 'Server returned error');
        }

    } catch (error) {
        console.error('Error:', error);
        let errorMessage = 'An error occurred while saving sales data.';

        if (error.responseJSON && error.responseJSON.message) {
            errorMessage = error.responseJSON.message;
        } else if (error.statusText) {
            errorMessage = error.statusText;
        }

        showErrorMessage('Error: ' + errorMessage);
    } finally {
        hideButtonLoading(submitBtn);
        submitBtn.prop('disabled', false);
    }
}


function showButtonLoading(button, text = 'Processing...') {
    button.data('original-text', button.html());
    button.html(`
        <div class="spinner-border spinner-border-sm text-light me-2" role="status">
            <span class="visually-hidden">Loading...</span>
        </div>
        ${text}
    `);
}

function hideButtonLoading(button) {
    const originalText = button.data('original-text');
    if (originalText) {
        button.html(originalText);
    }
}

// Message display functions
function showSuccessMessage(message) {
    // Using SweetAlert2 for better alerts (include SweetAlert2 library)
    if (typeof Swal !== 'undefined') {
        Swal.fire({
            icon: 'success',
            title: 'Success!',
            text: message,
            timer: 3000,
            showConfirmButton: false
        });
    } else {
        // Fallback to basic alert
        alert('Success: ' + message);
    }
}

function showErrorMessage(message) {
    if (typeof Swal !== 'undefined') {
        Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: message,
            timer: 5000
        });
    } else {
        alert('Error: ' + message);
    }
}





/*
function showButtonLoading(button, loadingText = 'Processing...') {
    // Save original content


    button.setAttribute('data-original-content', button.innerHTML);
    button.setAttribute('data-original-disabled', button.disabled);

    // Set loading state
    button.innerHTML = `
        <div class="spinner-border spinner-border-sm text-light me-2" role="status">
            <span class="visually-hidden">Loading...</span>
        </div>
        ${loadingText}
    `;
    button.disabled = true;

}

function hideButtonLoading(button) {
    // Restore original content


    const originalContent = button.getAttribute('data-original-content');
    const originalDisabled = button.getAttribute('data-original-disabled') === 'true';

    if (originalContent) {
        button.innerHTML = originalContent;
        button.disabled = originalDisabled;
    }
}


*/






    function resetButton(button) {
        button.innerHTML = 'Submit Sales';
        button.disabled = false;
    }



function prepareSalesData() {
    const items = [];

    $('#tableBody tr').each(function() {
        const row = $(this);
        const item = {
            item_name: row.find('td:eq(0)').text(),
            itemctrlnum: row.find('.itemctrlnum').text(),
            taxctrlnum: row.find('.taxctrlnum').text(),
            price: parseFloat(row.find('.price').text()),
            quantity: parseInt(row.find('.quantity-input').val()),
            total: parseFloat(row.find('.total').text())
        };

        // Validate each item
        if (!item.item_name || item.price <= 0 || item.quantity <= 0) {
            alert('Please check all items have valid data');
            return null;
        }

        items.push(item);
    });

    return items.length > 0 ? { items: items } : null;
}








document.getElementById('paymentMode').addEventListener('change', function() {
    const label = document.querySelector('label[for="paymentMode"]');
    label.textContent = this.checked ? 'Credit' : 'Cash';
});





/*

    $(function() {
        document.getElementById('searchresult').innerHTML = "";
        $('#searchresult').hide();
    });


    modechange = function(varStatus){
        $('#searchValue').val("");
        if(varStatus==1){
            $('#searchValue').attr('placeholder','Scan BarCode');
            $('#searchresult').hide();
            $('#EntryForm').show();
        } else {
            $('#searchValue').attr('placeholder','Enter Item Description');
            $('#searchresult').show();
            $('#EntryForm').hide();
            getItemslists();
        }
    }

    $('#searchValue').focusout(
        function(){
                    //gettig selected mode
               if($("input[name=mode]:checked").val() == 1){
                    ItemDetailsByBarCode($('#searchValue').val());
               } else {
                    ItemDetailsByDescription($('#searchValue').val());
               }
        }
    );


    $("#btnSave").click(function(){
        event.preventDefault();
        var url = "{{ route('sales.item.save', ":varOrderCtrlNum") }}";
        url = url.replace(':varOrderCtrlNum', $("#OrderCtrlNum").val());
        url = url.replace('?','/');
        $.ajax({
            type:'POST',
            url: url,
            data: $('#SalesItem').serialize(),
            success: function(response) {
                    //alert(response.product_name);
                    //setItemetails(response);

                  ItemBoughtList($("#OrderCtrlNum").val());

                },

            error: function(error) {
                    //alert(error.responseText);
                    console.log(error);
                }
        });
        clearEntries();
    });

    computeItemTotal = function(){
        valItemTotal = 0;
        $('#boughtItems tr').each(function(){
            var valQuantity = $(this).closest("tr").find('td:eq(1)').text();
            var valPrice = $(this).closest("tr").find('td:eq(2)').text();
            valItemTotal = valItemTotal + valQuantity * valPrice;
        })
        $('#gross').val(valItemTotal);
        NetTotal();
    }



    ItemDetailsByBarCode = function(varBarCode){
            var url = "{{ route('sales.item', ":varBarCode") }}";
            url = url.replace(':varBarCode', varBarCode);
            $.ajax({
                type: 'GET',
                url: url,
                //data: formData,
                dataType: 'json',
                success: function(response) {
                    //alert(response.text);
                    //alert(response.product_name);
                    setItemetails(response);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        $("#btnSave").focus();
    }




    ItemDetailsByBarCodeV2 = function(varBarCode){
            ItemDetailsByBarCode(varBarCode);
            $('#searchresult').hide();
            $('#EntryForm').show();
            $('#searchValue').val(varBarCode);


    }







    ItemDetailsByDescription = function(varBarCode){

            getItemslists();


            var url = "{{ route('sales.item.description', ":varBarCode") }}";
            url = url.replace(':varBarCode', varBarCode);



            $.ajax({
                type: 'GET',
                url: url,
                //data: formData,
                dataType: 'json',
                success: function(results) {

                    $('#ItemListsTable').html();
                     results.map(function(result){
                        console.log(result);
                        $('#ItemListsTable').append(`<tr><td>` + result.product_code + `</td><td><a href="#" onclick="ItemDetailsByBarCodeV2('` + result.barcode + `')"><i class="ri-gift-2-line wrapper-menu"></i></a></td></tr>`);
                     });


                },
                error: function(error) {
                    console.log(error);
                }
            });
        $("#btnSave").focus();
    }




    ItemBoughtList = function(ControlNum){
            //alert('Test');
            let varDefaault= "";
            var url = "{{ route('sales.item.boughtList', ":varBarCode") }}";
            url = url.replace(':varBarCode', ControlNum);
            //alert(url);
            $.ajax({
                type: 'GET',
                url: url,
                //data: formData,
                dataType: 'json',
                success: function(results) {
                    $('#boughtItems').html("");
                    results.map(function(result){
                        let varItemTotal = Number(result.price) * Number(result.quantity);
                        $('#boughtItems').append(varDefaault.concat(`<tr>
                                                                        <td>${result.product_name}</td>
                                                                        <td>${result.quantity}</td>
                                                                        <td>${result.price}</td>
                                                                        <td>${varItemTotal}</td>
                                                                        <td><form  enctype="multipart/form-data" id="ItemDel" >
                                                                            <button class"btn btn-primary" id="btnItemDel" name="btnItemDel" onclick="ItemDel('${ControlNum}','${result.id}')">Del</button>
                                                                            </form>
                                                                        </td>
                                                                    </tr>`));
                        computeItemTotal();
                        console.log(result.id);
                    });

                },
                error: function(error) {
                    //alert('Error');
                    console.log(error);
                }
            });
    }




    getItemslists = function(Items){
       $('#searchresult').html('<table class="table" id="ItemListsTable"><tr><th>Product</th><th>&nbsp;</th></tr></table>');
    }




    NetTotal = function(){
        //alert($('#tax').val() + $('#tax').val());
        let vatTotal = parseInt($('#gross').val()) + parseInt($('#tax').val()) - parseInt($('#discount').val());
        $('#grandtotal').val(vatTotal);
    }

    $('#discount').change(function(){
        NetTotal();
    });
    clearEntries = function(){
        $("#itemname").val();
        $("#price").val();
        $("#taxname").val();
        $("#quantity").val();
        $("#taxctrlnum").val();
        $("#itemctrlnum").val();
        $("#taxctrlnum").val();
        $("#taxname").val();
    }



    $("#quantity").focusout(
        function(){
            $("#btnSave").focus();
        }
    );

    $('#amtPaid').keyup(function(){
        if($('#amtPaid').val() >= $('#grandtotal').val()){
            varBalance = $('#amtPaid').val() - $('#grandtotal').val()
            $('#balance').val(varBalance)
        }
    });











$('#exampleModal').on('show.bs.modal', function (event) {
  var button = $(event.relatedTarget) // Button that triggered the modal
  var recipient = button.data('whatever') // Extract info from data-* attributes
  // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
  // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
  var modal = $(this)
  modal.find('.modal-title').text('Mini Calculator ')

  $("#CapturedAmount").val("0");

  modal.find('.modal-body input').val(recipient)
})




$('#CapturedAmount').focusout(function(){

    let varBalance = $("#CapturedAmount").val() - $("#grandtotal").val();
    $("#BalanceAmount").val(varBalance);
});

ItemDel = function(ControlNum,ItemId){
        event.preventDefault();


        var url = "{{route('sales.item.itemDelete',[':ControlNum',':ItemId'])}}";
        url = url.replace(':ControlNum', ControlNum);
        url = url.replace(':ItemId', ItemId);
        $.ajax({
            type: 'POST',
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf_token"]').attr('content')},
            url: url,
            success:function(result){
                console.log(result);
            },
            error:function(error){
                console.log(error);
            }
        });
    };

*/
</script>




@endsection
