@extends('dashboard.body.main')

@section('container')
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            @if (session()->has('success'))
                <div class="alert text-white bg-success" role="alert">
                    <div class="iq-alert-text">{{ session('success') }}</div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            @endif
            @if (session()->has('error'))
                <div class="alert text-white bg-danger" role="alert">
                    <div class="iq-alert-text">{{ session('success') }}</div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            @endif
            <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                <div>
                    <h4 class="mb-3">Product List</h4>

                </div>
                <div>
                    <!--
                    <a href="{{ route('products.importView') }}" class="btn btn-success add-list">Import</a>
                    <a href="{{ route('products.exportData') }}" class="btn btn-warning add-list">Export</a>
                    -->
                    <!-- <a href="{{ route('products.create') }}" class="btn btn-primary add-list">Add Product</a> -->
            
            
                </div>
            </div>
        </div>

        <div class="col-lg-12">
            <x-productsearch />
        </div>

        <div class="col-lg-12">
            <div class="table-responsive rounded mb-3">
                <table class="table mb-0">
                    <thead class="bg-white text-uppercase">
                        <tr class="ligth ligth-data">
                            <th>No.</th>
                            <!-- <th>Photo</th> -->
                            <th>@sortablelink('product_name', 'name')</th>
                            <th>@sortablelink('category.name', 'category')</th>
                            <th>@sortablelink('supplier.name', 'supplier')</th>
                            <th>@sortablelink('selling_price', 'selling price')</th>
                            <th>@sortablelink('buying_price', 'buying price')</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody class="ligth-body">
                        @forelse ($products as $product)



                        <tr>
                            
                            <!--
                            <td>
                                <img class="avatar-60 rounded" src="{{ $product->product_image ? asset('storage/products/'.$product->product_image) : asset('assets/images/product/default.webp') }}">
                            </td>
                            -->
                            <td>{{ $product->product_name }}</td>
                            <td>{{ $product->category_name }}</td>
                            <td>{{ $product->suppliers_name }}</td>
                            <td>{{ $product->selling_price }}</td>
                            <td>{{ $product->buying_price }}</td>
                            <td>
                                    <span class="badge rounded-pill bg-success">Valid</span>
                                  
                            </td>
                            <td>
                                
                                <ul class="list-inline">                            
                                    <li class="list-inline-item">
                                        <form action="{{route('inventory.home',[$product->id])}}" method="POST" style="margin-bottom: 5px">
                                            @method('POST')
                                            @csrf
                                            <button type="submit" class="btn  mr-2 border-none"  data-toggle="tooltip" data-placement="top" title="" data-original-title="Inventory"><i class="fa-solid fa-box-open mr-0"></i></button>
                                        </form>
                                    </li>                                
                                    <li class="list-inline-item">
                                
                                
                                        <form action="{{route('product.bycategory.view',[$product->id,$product->category_id])}}" method="POST" style="margin-bottom: 5px">
                                            @method('POST')
                                            @csrf
                                            <div class="d-flex align-items-center list-action">
                                                <a class="btn  mr-2" data-toggle="tooltip" data-placement="top" title="" data-original-title="barcode" href="{{route('product.item.barcode',$product->id)}}"><i class="ri-barcode-line mr-0"></i>
                                                </a>
                                        <!--
                                        <a class="btn  mr-2" data-toggle="tooltip" data-placement="top" title="" data-original-title="View"
                                            href=""><i class="ri-eye-line mr-0"></i>
                                        </a>
                                        <a class="btn  mr-2" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit"
                                            href=""><i class="ri-pencil-line mr-0"></i>
                                        </a>
                                        -->
                                                <button type="submit" class="btn  mr-2 border-none"  data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit"><i class="ri-eye-line mr-0"></i></button>
                                            </div>
                                        </form>
                                    </li>
                                </ul>                                    
                            </td>
                        </tr>

                        @empty
                        <div class="alert text-white bg-danger" role="alert">
                            <div class="iq-alert-text">Data not Found.</div>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <i class="ri-close-line"></i>
                            </button>
                        </div>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <!-- Page end  -->
</div>

@endsection
