@extends('dashboard.body.main')

@section('container')
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            @if (session()->has('success'))
                <div class="alert text-white bg-success" role="alert">
                    <div class="iq-alert-text">{{ session('success') }}</div>
                    <button type="button" class="btn close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            @endif
            <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                <div>
                    <h4 class="mb-3">Category List</h4>
                    <!--
                    <p class="mb-0">A Category dashboard lets you easily gather and visualize Category data from optimizing <br>
                        the Category experience, ensuring Category retention. </p>
                        -->
                </div>
                <div>
                <a href="{{ route('categories.create') }}" class="btn "><i class="fas fa-plus mr-3"></i>Create Category</a>
                <a href="{{ route('categories.index') }}" class="btn add-list"><i class="fa-solid fa-trash mr-3"></i>Clear Search</a>
                </div>
            </div>
        </div>

        <div class="col-lg-12">
            <form action="{{ route('Product.Search') }}" method="POST">
                @csrf()
                <div class="d-flex flex-wrap align-items-center justify-content-between">
                    <div class="form-group row">
                        <label for="row" class="col-sm-3 align-self-center">Row:</label>
                        <div class="col-sm-6">
                
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="control-label col-sm-5 align-self-center" for="search">Search Product:</label>
                        <div class="col-sm-7">
                            <div class="input-group">
                                <input type="text" id="search" class="form-control" name="search" placeholder="Search category" value="{{ request('search') }}">
                                <div class="input-group-append">
                                    <button type="submit" class="input-group-text bg-primary"><i class="fa-solid fa-magnifying-glass font-size-20"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    
                    
                </div>
            </form>
        </div>

        <div class="col-lg-12">
            <div class="table-responsive rounded mb-3">
                <table class="table mb-0">
                    <thead class="bg-white text-uppercase">
                        <tr class="ligth ligth-data">
                            <th>@sortablelink('Code')</th>
                            <th>@sortablelink('Description')</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody class="ligth-body">
                        @forelse ($categories as $category)
                        <tr>

                            <td>{{ $category->Code }}</td>
                            <td>{{ $category->Description }}</td>
                            <td>
                                <div class="d-flex align-items-center list-action">

                                    <form action="{{ route('subcategories.lists', $category->id) }}" method="POST" style="margin-bottom: 5px">
                                        @method('GET')
                                        @csrf
                                        <button type="submit" class="badge bg-warning mr-2 border-none" data-toggle="tooltip" data-placement="top" title="" data-original-title="Delete"><i class="ri-delete-bin-line mr-0"></i>Sub Category</button>
                                    </form>
                                <!--
                                    <a class="badge bg-success mr-2" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit"
                                        href="{{ route('categories.edit', $category->id) }}""><i class="ri-pencil-line mr-0"></i>
                                    </a>
                                    <form action="{{ route('categories.destroy', $category->id) }}" method="POST" style="margin-bottom: 5px">
                                        @method('delete')
                                        @csrf
                                        <button type="submit" class="badge bg-warning mr-2 border-none" onclick="return confirm('Are you sure you want to delete this record?')" data-toggle="tooltip" data-placement="top" title="" data-original-title="Delete"><i class="ri-delete-bin-line mr-0"></i></button>
                                    </form>
                                -->
                                </div>
                            </td>
                        </tr>

                        @empty
                        <div class="alert text-white bg-danger" role="alert">
                            <div class="iq-alert-text">Data not Found.</div>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <i class="ri-close-line"></i>
                            </button>
                        </div>
                        @endforelse
                    </tbody>
                </table>
            </div>
            {{ $categories->links() }}
        </div>
    </div>
    <!-- Page end  -->
</div>

@endsection
