@extends('dashboard.body.main')

@section('container')

<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            @if (session()->has('success'))
                <div class="alert text-white bg-success" role="alert">
                    <div class="iq-alert-text">{{ session('success') }}</div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            @endif
            @if (session()->has('error'))
                <div class="alert text-white bg-danger" role="alert">
                    <div class="iq-alert-text">{{ session('success') }}</div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            @endif
            <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                <div>
                    <h4 class="mb-3">{{ $store->name }}</h4>

                </div>
                <div>
                    <!--
                    <a href="{{ route('products.importView') }}" class="btn btn-success add-list">Import</a>
                    <a href="{{ route('products.exportData') }}" class="btn btn-warning add-list">Export</a>
                    -->
                    <!-- <a href="{{ route('products.create') }}" class="btn btn-primary add-list">Add Product</a> -->
                    <form method="POST" action="{{route('stores.create')}}">
                        @csrf
                        @method('GET')
                        <button class="btn">Add Store</button>
                    </form>
                </div>
            </div>
        </div>
    </div>




    <table class="table">
        @foreach($products as $product)
            <tr>
                <td>{{$product->product_code}}</td>
                <td>
                    <form method="POST" action="{{route('inventory.product',[$store->id,$product->id,])}}">
                        @csrf
                        <button type="submit" class="btn"><i class="fa fa-check"></i></button>
                    </form>
                </td>
            </tr>

        @endforeach
    </table>




</div>

@endsection
