@extends('dashboard.body.main')

@section('container')




         <div class="row">
                <div class="col-lg-12">
                    @if (session()->has('success'))
                        <div class="alert text-white bg-success" role="alert">
                            <div class="iq-alert-text">{{ session('success') }}</div>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <i class="ri-close-line"></i>
                            </button>
                        </div>
                    @endif
                    <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                        <div>
                            <h4 class="mb-3">  {{$glaccount->code }}   {{ ($id==1)?'Revenue':'Expenditure' }}s List</h4>
                        </div>
                        <div>
                            <ul class="list-inline">
                                <li class="list-inline-item">
                                    <form method="POST" action="{{route('RevExp.assign',[$id,$glaccount->id])}}">
                                        @csrf
                                        <button type="submit" class="btn"> Add </button>
                                    </form>
                                </li>
                                <li class="list-inline-item">
                                    <a href="{{ route('RevExp.Home',[$id]) }}" class="btn ">Cancel</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
         </div>



        <div>
            <table class="table">
                    <tr>
                        <th class="col-2"></td>
                        <th class="col-2">Apply Date</td>
                        <th class="col-5">Supplier</td>
                        <th class="text-right">Amount</td>
                    </tr>
                    @foreach($revexptrans as $revexptran)
                    
                   
                        <tr>
                            <td class="col-2"> 
                                <ul class="list-inline">
                                    <li class="list-inline-item">
                                        <form method="POST" action="{{route('RevExp.viewtransaction',[$revexptran->id,$id])}}">
                                            @csrf
                                            <button type="submit" class="btn">View</button>
                                        </form>
                                    </li>
                                    <li class="list-inline-item">
                                        <form method="POST" action="{{route('RevExp.postransaction',[$revexptran->id,$id])}}">
                                            @csrf
                                            <button type="submit" class="btn">Post</button>
                                        </form>
                                    </li>
                                </ul> 
                            </td>
                            <td class="col-2">{{ $revexptran->applydate }}</td>
                            <td class="col-5">{{ $revexptran->name }}</td>
                            <td class="text-right">{{$revexptran->Code}} {{ number_format($revexptran->amount,2) }}</td>
                        </tr>
                    @endforeach
            </table>
        </div>


@endsection
