@extends('dashboard.body.main')

@section('container')
<div class="container-fluid">


    <form method="POST" action="{{route('RevExp.UpdateTransaction',[$id,$RevExpTransaction->id])}}">

         <div class="row">
                <div class="col-lg-12">
                    @if (session()->has('success'))
                        <div class="alert text-white bg-success" role="alert">
                            <div class="iq-alert-text">{{ session('success') }}</div>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <i class="ri-close-line"></i>
                            </button>
                        </div>
                    @endif
                    <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                        <div>
                            <h4 class="mb-3">{{ ($id==1)?'Revenue':'Expenditure' }} Capturing</h4>
                        </div>
                        <div>
                            <ul class="list-inline">
                                <li class="list-inline-item">
                                    <a href="{{ route('RevExp.Home',[$id]) }}" class="btn ">Delete</a>
                                </li>
                                <li class="list-inline-item">
                                        @csrf
                                        <button type="submit" class="btn"> update </button>
                                </li>
                                <li class="list-inline-item">
                                    <a href="{{ route('RevExp.Home',[$id]) }}" class="btn ">Cancel</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
         </div>

        <div class="form-group row">
          <label class="control-label col-sm-2">gl Code:</label>
          <div class="col-sm-4">
            <input type="text" class="form-control" id="Code" name="Code" placeholder="Enter Code" name="pwd" value="{{$glaccount->glcode}}-{{$glaccount->code}}">
          </div>
        </div>



        <div class="input-group mb-3 row">
            <label class="control-label col-sm-2" for="pwd">Supplier:</label>
            <div class="col-sm-4">
                <div class="input-group mb-3">
                      <input type="text" class="form-control" id="supplierName" name="supplierName" placeholder="Select Supplier" value="{{$SelectedSuppliers->name}}">
                      <input type="hidden" class="form-control" id="supplierId" name="supplierId" placeholder="Select Supplier" value="{{$RevExpTransaction->Supplier}}">
                      <div class="input-group-append">
                            <button class="btn btn-outline-secondary" type="button"  data-bs-toggle="modal" data-bs-target="#myModal">Supplier</button>
                      </div>
                </div>
            </div>
        </div>


        <div class="form-group row">
          <label class="control-label col-sm-2" for="pwd">Apply Date:</label>
          <div class="col-sm-4">
            <input type="date" class="form-control" id="ApplyDate" name="ApplyDate" placeholder="Enter Apply Date" value="{{$RevExpTransaction->applydate}}">
          </div>
        </div>
        <div class="form-group row">
          <label class="control-label col-sm-2" for="pwd">Reference Num:</label>
          <div class="col-5">
                <input type="text" class="form-control" id="ReferenceNum" name="ReferenceNum" placeholder="Enter ReferenceNum" value="{{$RevExpTransaction->RefNum}}">
          </div>
        </div>
        <div class="form-group row">
          <label class="control-label col-sm-2" for="pwd">Amount:</label>
          <div class="col-sm-4">
              <div class="input-group mb-3">
                <select class="form-control col-3" name="currency" id="currency">
                    @foreach($currencies as $currency)
                        <option value="{{$currency->ControlNum}}"> {{$currency->Code}}</option>
                    @endforeach
                </select>
                <input type="text" class="form-control" id="Amount" name="Amount" placeholder="enter Amount" value="{{$RevExpTransaction->amount}}">
              </div>
          </div>
        </div>
        <div class="form-group row">
          <label class="control-label col-sm-2" for="pwd">Notes:</label>
          <div class="col-sm-5">
            <input type="text" class="form-control" id="Notes" name="Notes" placeholder="Enter Description" value="{{$RevExpTransaction->Notes}}">
          </div>
        </div>

    </form>

</div>










<!-- The Modal -->
<div class="modal" id="myModal">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title">Supplier List</h4>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <!-- Modal body -->
      <div class="modal-body">
          <ul>
                @foreach($Suppliers as $Supplier)
                    <li><h href="#" onclick="supplydetaisl('{{$Supplier->id}}','{{$Supplier->name}}')" data-bs-dismiss="modal"> {{ $Supplier->id }}-{{ $Supplier->name }} </a></li>
                @endforeach
            </ul>
      </div>
    </div>
  </div>
</div>




<script>
    function supplydetaisl(id,Code){
         $("#supplierName").val(Code);
         $("#supplierId").val(id);
    }
</script>


@endsection
