@extends('dashboard.body.main')

@section('container')
<div class="col-12">

</div>
<div class="flex-auto flex flex-col" id="dashboard-content">

        <div class="px-4 row">
            <div class="col-4 mb-4">
                <h3 class="text-3xl text-primary font-bold">Supplier Outstanding Report</h3>
            </div>
            <div class="col-8">
                <form method="POST" action="{{ route('outstanding.index') }}">
                    @csrf
                    <ul class="list-inline">

                        <li  class="list-inline-item">
                            <button class="rounded flex justify-between text-primary shadow py-1 items-center  px-2">
                                    <i class="las la-sync-alt text-xl"></i>
                                    <span class="pl-2">Load </span>
                            </button>
                        </li>
                        <li  class="list-inline-item">
                            <a  class="btn rounded flex justify-between text-primary shadow py-1 items-center  px-2" target="_blank" href="{{route('outstanding.pdf')}}">
                                <i class="las la-print text-xl"></i>
                                <span class="pl-2">Print</span>
                            </a>
                        </li>
                    </ul>
                </form>


            </div>
        </div>
        <div class="row">
            <table class="table">
                @php
                    $PurAmount = 0;
                    $PayAmount = 0;
                @endphp
                @foreach($pendings as $pending)
                @php
                    $PurAmount += $pending->PurAmount;
                    $PayAmount += $pending->PayAmount;
                @endphp

                    <tr>
                        <td>{{$pending->Supplier}}</td>
                        <td>{{$pending->name}}</td>
                        <td>{{$pending->Currency}}</td>
                        <td style="text-align:right">{{number_format($pending->PurAmount,2)}}</td>
                        <td style="text-align:right">{{number_format($pending->PayAmount,2)}}</td>
                    </tr>
                @endforeach

                <tr>
                    <td colspan="3"></td>
                    <td style="text-align:right">{{number_format($PurAmount,2)}}</td>
                    <td style="text-align:right">{{number_format($PayAmount,2)}}</td>
                </tr>


            </table>
        </div>




</div>




@endsection
