@extends('dashboard.body.main')

@section('container')
<div class="col-12">

</div>

<div class="flex-auto flex flex-col" id="dashboard-content">



        <div class="px-4 row">
            <div class="col-4 mb-4">
                <h3 class="text-3xl text-primary font-bold">Daily Sales Report</h3>
            </div>
            <div class="col-8">


                <form method="POST" action="{{route('dailysales.report')}}">
                    @csrf
                    <ul class="list-inline">
                        <li  class="list-inline-item  col-4">
                            <div class="form-floating">
                                <input type="date" class="form-control" id="StartDate" name="StartDate" placeholder="Start Date" value="{{$ReportParam['Start_Date']}}">
                                <label for="floatingPassword">Start Date</label>
                            </div>
                        </li>
                        <li  class="list-inline-item col-4">
                            <div class="form-floating">
                                <input type="date" class="form-control" id="EndDate" name="EndDate" placeholder="End Date" value="{{$ReportParam['End_Date']}}">
                                <label for="floatingPassword">End Date</label>
                            </div>
                        </li>
                        <li  class="list-inline-item">
                            <button @click="loadReport()" class="rounded flex justify-between text-primary shadow py-1 items-center  px-2">
                                    <i class="las la-sync-alt text-xl"></i>
                                    <span class="pl-2">Load</span>
                            </button>
                        </li>
                        <li  class="list-inline-item">
                            <button @click="printSaleReport()" class="rounded flex justify-between text-primary shadow py-1 items-center  px-2">
                                <i class="las la-print text-xl"></i>
                                <span class="pl-2">Print</span>
                            </button>
                        </li>
                    </ul>
                </form>


            </div>
        </div>

        <div class="row">
                @foreach($StoreDailySales as $StoreDailySale)
                    <div class="card col-4">
                      <div class="card-body">
                        <h5 class="card-title">{{$StoreDailySale->name}}</h5>
                        <h3 class="card-text">TZS {{ number_format($StoreDailySale->Total,2) }}</h3>
                        <form method="POST" action="{{route('dailysales.detailed.report',[$StoreDailySale->id,$ReportParam['Start_Date'],$ReportParam['End_Date']])}}">
                            @csrf
                            <button type="submit" class="btn">View Details</button>
                        </form>
                      </div>
                    </div>
                @endforeach
        </div>

        <div class="row">
            <div class="col-12">
            </div>
            <div id="report-section" class="px-4 info-div overflow-auto" style="height: 500px; width:100%;">


                <table class="table">

                    <tr>
                        <th>Date</th>
                        <th>Order Number</th>
                        <th>Product</th>
                        <th style="text-align: left">Unit</th>
                        <th style="text-align: right">Quantity</th>
                        <th style="text-align: right">Tax Amount </th>
                        <th style="text-align: right">Item Amount</th>
                        <th style="text-align: right">Item Total</th>

                    </tr>
                @php $total = 0; @endphp
                @foreach($dailySales as $dailySale)
                    @php
                        $ItemAmount = $dailySale->quantity * $dailySale->price;
                        $total += $ItemAmount;
                    @endphp
                    <tr>
                        <td>{{date_format(date_create($dailySale->applydate),"d-m-Y")}}</td>
                        <td>{{$dailySale->OrderCtrlNum}}</td>
                        <td>{{$dailySale->product_code}}</td>
                        <td style="text-align: left">{{$dailySale->Code}}</td>
                        <td style="text-align: right;">{{number_format($dailySale->quantity,2)}}</td>
                        <td style="text-align: right;">{{number_format($dailySale->taxAmount,2)}}</td>
                        <td style="text-align: right;">{{number_format($dailySale->price,2)}}</td>
                        <td style="text-align: right;">{{number_format($ItemAmount,2)}}</td>
                    </tr>
                @endforeach

                    <tr>
                        <td colspan="7"><b>Total</b></td>
                        <td style="text-align: right;"><b> {{number_format($total,2)}}</b></td>
                    </tr>
                </table>


            </div>
        </div>




</div>


@endsection

@section('specificpagescripts');
<script>
    loadReport();
</script>


@endsection
