@extends('dashboard.body.main')

@section('container')



<div class="col-12">

</div>

<div class="flex-auto flex flex-col" id="dashboard-content">
        <div class="px-4 row">
            <div class="col-4 mb-4">
                <h3 class="text-3xl text-primary font-bold">Daily Sales Report</h3>
            </div>
            <div class="col-8">
                <form method="POST" action="{{route('Stocklevels.Store.report')}}">
                    @csrf
                    <ul class="list-inline">
                        <li  class="list-inline-item  col-4">
                            <div class="form-floating">
                                <SELECT class="form-control" id="store" name="store" placeholder="store">
                                        @foreach($StoreLists as $StoreList)
                                            <option value="{{$StoreList->id}}"  {{($Store == $StoreList->id) ? 'selected':'' }}>{{$StoreList->name}}</option>
                                        @endforeach
                                    </SELECT>
                                
                                
                                <label for="floatingPassword">Store</label>
                            </div>
                        </li>
                        <li  class="list-inline-item">
                            <button @click="loadReport()" class="rounded flex justify-between text-primary shadow py-1 items-center  px-2">
                                    <i class="las la-sync-alt text-xl"></i>
                                    <span class="pl-2">Load</span>
                            </button>
                        </li>
                        <li  class="list-inline-item">
                            <button @click="printSaleReport()" class="rounded flex justify-between text-primary shadow py-1 items-center  px-2">
                                <i class="las la-print text-xl"></i>
                                <span class="pl-2">Print</span>
                            </button>
                        </li>
                    </ul>
                </form>


            </div>
        </div>



        <div class="row">
            <div class="col-12">
            </div>
            <div id="report-section" class="px-4 info-div overflow-auto" style="height: 500px; width:100%;">


                <table class="table">

                    <tr>
                        <th>Name</th>
                        <th>Supplier</th>
                        <!--
                        <th style="text-align: right">Factors</th>
                        <th style="text-align: center" colspan="2">Quantity</th>
                        -->
                        <th style="text-align: center" colspan="2">Quantity</th>

                    </tr>
                    @foreach($ItemStockLevels  as $ItemStockLevel)
                        <tr>
                            <td>{{ $ItemStockLevel->product_code }}</td>
                            <td>{{ $ItemStockLevel->product_code }}</td>
                            <!--
                            <td style="text-align: right">{{ $ItemStockLevel->factor }} </td>
                            <td>{{ (($ItemStockLevel->Quantity - ($ItemStockLevel->Quantity%$ItemStockLevel->factor))/$ItemStockLevel->factor) }} {{ $ItemStockLevel->BuyingUnitCode }}</td>

                            <td>{{ $ItemStockLevel->Quantity%$ItemStockLevel->factor }} {{ $ItemStockLevel->SellingUnitCode }}</td>
                            -->
                            <td>{{ $ItemStockLevel->Quantity }} {{ $ItemStockLevel->SellingUnitCode }}</td>

                        </tr>
                    @endforeach
                </table>


            </div>
        </div>




        <div class="row">
            <div class="col-12">
            </div>
            <div id="report-section" class="px-4 info-div overflow-auto" style="height: 500px; width:100%;">

            </div>
        </div>




</div>


@endsection

@section('specificpagescripts');
<script>
    loadReport();
</script>


@endsection

















