@extends('dashboard.body.main')

@section('container')
<div class="col-12">

</div>

<div class="flex-auto flex flex-col" id="dashboard-content">
        <div class="px-4 row">
            <div class="col-4 mb-4">
                <h3 class="text-3xl text-primary font-bold">Purchases List Report</h3>
            </div>
            <div class="col-8">
                <form method="POST" action="{{route('repPurchases.index')}}">
                    @csrf
                    <ul class="list-inline">
                        <li  class="list-inline-item">
                            <button @click="printSaleReport()" class="rounded flex justify-between text-primary shadow py-1 items-center  px-2">
                                <i class="las la-print text-xl"></i>
                                <span class="pl-2">Print</span>
                            </button>
                            <a href="{{route('Stocklevels.pdf')}}" target="_blank" class="btn">
                                <i class="las la-print text-xl"></i>
                                <span class="pl-2">Print</span>
                            </a>
                        </li>
                    </ul>
                </form>


            </div>
        </div>

        <div class="row">
            <div class="col-12">
            </div>
            <div id="report-section" class="px-4 info-div overflow-auto" style="height: 500px; width:100%;">


                <table class="table">

                    <tr>
                        <th>Name</th>
                        <th>Supplier</th>
                        <th style="text-align: right">Factors</th>
                        <th style="text-align: center" colspan="2">Quantity</th>

                    </tr>
                    @foreach($ItemStockLevels  as $ItemStockLevel)
                        <tr>
                            <td>{{ $ItemStockLevel->product_code }}</td>
                            <td>{{ $ItemStockLevel->product_code }}</td>
                            <td style="text-align: right">{{ $ItemStockLevel->factor }} </td>
                            <td>{{ (($ItemStockLevel->Quantity - ($ItemStockLevel->Quantity%$ItemStockLevel->factor))/$ItemStockLevel->factor) }} {{ $ItemStockLevel->BuyingUnitCode }}</td>

                            <td>{{ $ItemStockLevel->Quantity%$ItemStockLevel->factor }} {{ $ItemStockLevel->SellingUnitCode }}</td>

                        </tr>
                    @endforeach
                </table>


            </div>
        </div>




</div>


@endsection

@section('specificpagescripts');

@endsection
