@extends('Reports.dashboard')

@section('container')


<div class="flex-auto flex flex-col" id="dashboard-content">
        <div class="px-4 row">
            <x-report_header>
                Product List Report
            </x-report_header>
        </div>

        <div class="row">
            <div class="col-12">
            </div>
            <div id="report-section" class="px-4 info-div overflow-auto" style="height: 500px; width:100%;">
                <table class="table" style="width:100%">

                    <tr>
                        <th ></th>
                        <th colspan="2"> Unit</th>
                        <th class="text-align: right;">Quantity</th>
                        <th class="text-align: right;" colspan="2"> Price </th>
                        <th  colspan="2">Profit </th>
                    </tr>


                    <tr>
                        <th style="text-align: left;">Product</th>
                        <th style="text-align: left;">Buying</th>
                        <th style="text-align: left;">Selling</th>
                        <th class="text-align: right;">PCS</th>
                        <th style="text-align: right;">Buying </th>
                        <th style="text-align: right;">Selling</th>
                        <th style="text-align: right;">Item</th>
                        <th style="text-align: right;">Total</th>
                    </tr>

                @foreach($products as $product)
                    <tr>
                        <td>{{$product->product_code}}</td>
                        <td style="text-align: left;">{{$product->BuyingUnit}}</td>
                        <td style="text-align: left;">{{$product->SellingUnit}}</td>
                        <td style="text-align: center;">{{$product->factor}}</td>

                        <td style="text-align: right;">{{$product->buying_price}}</td>
                        <td style="text-align: right;">{{$product->selling_price}}</td>

                        <td style="text-align: right;">{{number_format(($product->selling_price - ($product->buying_price/$product->factor)),2)}}</td>
                        <td style="text-align: right;">{{number_format((($product->selling_price * $product->factor) - $product->buying_price),2) }}</td>
                    </tr>
                @endforeach
                </table>
            </div>
        </div>




</div>


@endsection


