<?php

namespace App\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use DB;

class CashierPrinter extends Component
{

    /**
     * Create a new component instance.
     */
    public $SalesCtrlNum;
    public function __construct($SalesCtrlNum)
    {
        $this->SalesCtrlNum = $SalesCtrlNum;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {

        $soldItems = DB::SELECT("select a.itemctrlnum,
                                        b.product_code,
                                        b.product_code,
                                        a.taxCtrlNum,
                                        a.taxAmount,
                                        a.quantity,
                                        a.price
                                from    sales_item_dets a,
                                        products b
                                WHERE   a.itemctrlnum = b.id
                                AND     a.OrderCtrlNum = ?",[$this->ControlNum]);
        return view('components.cashier-printer',compact('soldItems'));
    }
}
