<?php

namespace App\Listeners;

use App\Events\PO_Complete;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

use App\Models\Product;

use App\Models\stocklevel;
use App\Models\storestocklevel;

use App\Models\POReceives;

use DB;




class updatestorestock
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(PO_Complete $event): void
    {
        $POReceives = new POReceives();
        $ControlNum = $event->ControlNum;
        
        
        /*
        GET LIST of order undelivered from a particular store
        From SELECT `id`, `Store`, `POCtrlNum`, `ItemCtrlNum`, `quantity`, `delQty` FROM `po_store_item_qty`
        */
        $orderLists = DB::SELECT("SELECT id, Store,POCtrlNum, ItemCtrlNum,quantity, delQty FROM po_store_item_qty WHERE POCtrlNum = ?",[$ControlNum]);
        
        
        
     
        
        
        
        foreach($orderLists as $orderList){
            DB::UPDATE("UPDATE po_store_item_qty SET delQty = ? WHERE id = ?",[$orderList->quantity,$orderList->id,]);
            
            $product = Product::find($orderList->ItemCtrlNum);
            
            
            
            DB::UPDATE("UPDATE stocklevels SET Quantity =  Quantity + ?  WHERE ItemCtrlNum = ? ",[$orderList->quantity * $product->factor,$orderList->ItemCtrlNum]);
            
            if (storestocklevel::where('StoreCtrlNum',$orderList->Store)->where('ItemCtrlNum',$orderList->ItemCtrlNum)->where('StoreCtrlNum',$orderList->Store)->exists()) {
                DB::UPDATE("UPDATE storestocklevels SET Quantity = Quantity + ? WHERE  ItemCtrlNum = ?  AND StoreCtrlNum = ?",[$orderList->quantity * $product->factor,$orderList->ItemCtrlNum,$orderList->Store]);
            } else {
                storestocklevel::create([
                    'StoreCtrlNum'=>$orderList->Store, 
                    'ItemCtrlNum'=>$orderList->ItemCtrlNum, 
                    'Quantity'=>$orderList->quantity * $product->factor
                    ]);
            }
            
                //    DB::UPDATE("UPDATE storestocklevels SET Quantity = Quantity + ? WHERE  ItemCtrlNum = ?  AND StoreCtrlNum = ?",[$orderList->quantity * $product->factor,$orderList->ItemCtrlNum,$orderList->Store]);
       
            
            $POReceives = new POReceives();
            $POReceives->PurchaseCtrlNum = $orderList->POCtrlNum;
            $POReceives->Item = $orderList->ItemCtrlNum;
            $POReceives->QtyReceived = $orderList->quantity;
            $POReceives->store = $orderList->Store;
            $POReceives->ApplyDate  = '2025-01-15';
            $POReceives->UserId = Auth()->user()->id;
            $POReceives->save();       
       
        }        
        
        

    }
}
