<?php

namespace App\Listeners;

use App\Events\stockadjustment;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

use App\Models\inventory\storestocklvl;
use App\Models\Product;
use DB;

use auth;

class adjUpdateStockLevelstore
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
     
    }

    /**
     * Handle the event.
     */
    public function handle(stockadjustment $event): void
    {


        $storestocklvl =  new storestocklvl();
        $product = Product::find($event->adjustStock->product);

       // dd($event->adjustStock->unit);



        //Buying unit the you have to multiply by factor
        if ( intval($event->adjustStock->unit) == $product->BuyingUnit){

            if ($event->adjustStock->type == -1){
                //decrease
                //$stocklevel->Quantity = $stocklevel->Quantity  - ($event->adjustStock->quantity * $product->factor);

                if(storestocklvl::SELECT('*')->WHERE('StoreCtrlNum',$event->adjustStock->storeid)->exists()){
                    DB::SELECT("UPDATE storestocklevels
                                SET Quantity = Quantity - ? * $product->factor
                                WHERE StoreCtrlNum = ?
                                AND ItemCtrlNum = ?",[$event->adjustStock->quantity,$event->adjustStock->storeid,$event->adjustStock->product]);
                } else {
                    $storestocklvl->StoreCtrlNum = $event->adjustStock->storeid;
                    $storestocklvl->ItemCtrlNum = $event->adjustStock->product;
                    $storestocklvl->Quantity = -$event->adjustStock->quantity * $product->factor;
                    $storestocklvl->save();
                };
            }
            if ($event->adjustStock->type ==  1){
                //Increase
                if(storestocklvl::SELECT('*')->WHERE('StoreCtrlNum',$event->adjustStock->storeid)->exists()){
                    DB::SELECT("UPDATE storestocklevels
                                SET Quantity = Quantity + ? * $product->factor
                                WHERE StoreCtrlNum = ?
                                AND ItemCtrlNum = ?",[$event->adjustStock->quantity,$event->adjustStock->storeid,$event->adjustStock->product]);
                } else {
                    $storestocklvl->StoreCtrlNum = $event->adjustStock->storeid;
                    $storestocklvl->ItemCtrlNum = $event->adjustStock->product;
                    $storestocklvl->Quantity = $event->adjustStock->quantity * $product->factor;
                    $storestocklvl->save();
                };
            }
        }

        //You do not have to multiply by factor
        if (intval($event->adjustStock->unit) == $product->SellingUnit){

            if ($event->adjustStock->type == -1){
                //decrease
                //$stocklevel->Quantity = $stocklevel->Quantity  - ($event->adjustStock->quantity * $product->factor);

                if(storestocklvl::SELECT('*')->WHERE('StoreCtrlNum',$event->adjustStock->storeid)->exists()){
                    DB::SELECT("UPDATE storestocklevels
                                SET Quantity = Quantity - ?
                                WHERE StoreCtrlNum = ?
                                AND ItemCtrlNum = ?",[$event->adjustStock->quantity,$event->adjustStock->storeid,$event->adjustStock->product]);
                } else {
                    $storestocklvl->StoreCtrlNum = $event->adjustStock->storeid;
                    $storestocklvl->ItemCtrlNum = $event->adjustStock->product;
                    $storestocklvl->Quantity = -$event->adjustStock->quantity;
                    $storestocklvl->save();
                };
            }
            if ($event->adjustStock->type ==  1){
                //Increase
                if(storestocklvl::SELECT('*')->WHERE('StoreCtrlNum',$event->adjustStock->storeid)->exists()){
                    DB::SELECT("UPDATE storestocklevels
                                SET Quantity = Quantity + ?
                                WHERE StoreCtrlNum = ?
                                AND ItemCtrlNum = ?",[$event->adjustStock->quantity,$event->adjustStock->storeid,$event->adjustStock->product]);
                } else {
                    $storestocklvl->StoreCtrlNum = $event->adjustStock->storeid;
                    $storestocklvl->ItemCtrlNum = $event->adjustStock->product;
                    $storestocklvl->Quantity = $event->adjustStock->quantity;
                    $storestocklvl->save();
                };
            }
        }


    }
    
    
    
    
    
    
}
