<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;


use App\Models\stores;
use App\Models\Product;
use App\Models\Unit;
use App\Models\storeitemprice;
use DB;
class storeprice extends Controller
{
    /**
     * Display a listing of the resource.
     */


    public function storepriceindex($storeid){

        $StoreItems = DB::SELECT("SELECT a.storeid, a.productid,b.product_code,a.price FROM storeprices a, products b WHERE a.productid = b.id AND storeid = ? ",[$storeid]);
        $store = stores::find($storeid);
        return view('storeprice.index',compact("store","StoreItems"));
    }

    public function storepriceitemlist($storeid){
        $Products = DB::SELECT("SELECT * FROM products order by product_code");
        $store = stores::find($storeid);
        return view('storeprice.itemlist',compact("store","Products"));
    }
    public function createstorepriceitem($storeid,$ItemId){
        $store = stores::find($storeid);
        $product = Product::find($ItemId);
        $unit = Unit::find($product->SellingUnit);


        return view('storeprice.createstoreprice',compact('store','product','unit'));
    }


    public function storepriceitemsave($storeid,$ItemId,Request $request){
        $storeitemprice = new storeitemprice();

        //dd(DB::table('storeprices')->select('*')->WHERE('storeid',$storeid)->WHERE('productid',$ItemId)->exists());
        if(DB::table('storeprices')->select('*')->WHERE('storeid',$storeid)->WHERE('productid',$ItemId)->exists()){
            $store = stores::find($storeid);
            $product = Product::find($ItemId);
            $unit = Unit::find($product->SellingUnit);
            return redirect()->route('createstoreprice.itemlist',[$store,$product,$unit])->with('success',"Store Item Price Exist, Edit ");
        } else {
            $storeitemprice::create(['storeid'=>$storeid,'productid'=>$ItemId,'userid'=>auth()->user()->id,'price'=>$request->price]);
        }


        return redirect()->route("store.price.index",$storeid);
    }



    public function storepriceitemdelete($store, $item){
        DB::DELETE("Delete from storeprices WHERE storeid = ? AND productid = ?",[$store, $item]);
        return redirect()->route('store.price.index',$store);
    }

    public function storepriceitemedit($storeid, $ItemId){
        $store = stores::find($storeid);
        $product = Product::find($ItemId);
        $unit = Unit::find($product->SellingUnit);
        $storeprice = DB::TABLE("storeprices")->SELECT('storeid','productid', 'price' )->WHERE('storeid',$storeid)->where('productid',$ItemId)->FIRST();
        //DD($storeprice);
        return view('storeprice.editstoreprice',compact('storeprice','store','product','unit'));

    }

    public function storepriceitemupdate($storeid, $ItemId,Request $request){


        DB::SELECT("UPDATE storeprices SET price = ? WHERE storeid = ? AND productid = ?",[$request->price,$storeid, $ItemId]);
        return redirect()->route('store.price.index',$storeid);
    }

















    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
