<?php

namespace App\Http\Controllers\inventory;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;


use App\Models\Product;
use App\Models\Category;
use App\Models\POReceives;
use App\Models\Unit;
use App\Models\adjustmentQty;

use App\Models\stores;


use App\Events\stockadjustment;
use DB;
use auth;


class home extends Controller
{

    public function user_validation(){
         if(auth()->user()->store==0){
                return view('sales.error');
        }
    }
    
    protected function product_details($productid){

        $this->user_validation();
        
        $product = Product::findorfail($productid);
        return $productStckDet = array(
            'product'=> Product::findorfail($productid),
            'BuyingUnit' => Unit::findorfail($product->BuyingUnit),
            'SellingUnit' => Unit::findorfail($product->SellingUnit),
            'category' => Category::findorfail($product->category_id ),
            'PurTotal' => DB::table('PO_receives')->where('Item',$productid)->sum('QtyReceived'),
            'SalesTotal' => DB::table('sales_item_dets')->where('itemctrlnum',$productid)->sum('quantity'),
            'stocklevel' => DB::table('stocklevels')->where('ItemCtrlNum',$productid)->sum('Quantity'),
        );
    }
    public function product($productid){

        $this->user_validation();
        
        $product = Product::findorfail($productid);
        $BuyingUnit = Unit::findorfail($product->BuyingUnit);
        $SellingUnit = Unit::findorfail($product->SellingUnit);
        $category = Category::findorfail($product->category_id );
        $PurTotal = DB::table('PO_receives')->where('Item',$productid)->sum('QtyReceived');
        $SalesTotal = DB::table('sales_item_dets')->where('itemctrlnum',$productid)->sum('quantity');
        $stocklevel = DB::table('stocklevels')->where('ItemCtrlNum',$productid)->sum('Quantity');



        return view('inventory.home.product',compact('product','category','PurTotal','SalesTotal','stocklevel','BuyingUnit','SellingUnit'));
    }


    public function adjustment($productid){


        $this->user_validation();
        
        
        $stores = stores::all();
        
        

        $product = Product::findorfail($productid);
        $BuyingUnit = Unit::findorfail($product->BuyingUnit);
        $SellingUnit = Unit::findorfail($product->SellingUnit);
        $category = Category::findorfail($product->category_id );
        $PurTotal = DB::table('PO_receives')->where('Item',$productid)->sum('QtyReceived');
        $SalesTotal = DB::table('sales_item_dets')->where('itemctrlnum',$productid)->sum('quantity');
        $stocklevel = DB::table('stocklevels')->where('ItemCtrlNum',$productid)->sum('Quantity');
        $units = DB::SELECT("SELECT a.BuyingUnit UnitId,b.Code FROM products a, units b WHERE a.BuyingUnit= b.id AND a.id = ?
                            UNION ALL
                            SELECT a.SellingUnit UnitId,b.Code FROM products a, units b WHERE a.SellingUnit= b.id AND a.id = ?
                            ",[$productid,$productid]);

        return view('inventory.home.adjustment',compact('product','category','PurTotal','SalesTotal','stocklevel','BuyingUnit','SellingUnit','units','stores'));
    }

    public function save(Request $request, Int $productId){
        
        
 
        
        $this->user_validation();
        $request->validate([
            'applydate'=>'required'
        ]);
        
        
        
        $adjustmentQty = new adjustmentQty();
        $adjustmentQty->product = $productId;
        $adjustmentQty->applydate = $request->applydate;
        $adjustmentQty->type = $request->type;
        $adjustmentQty->quantity = $request->quantity;
        $adjustmentQty->unit = $request->unit;
        $adjustmentQty->remarks = $request->remarks;
        $adjustmentQty->userid = auth()->user()->id;
        $adjustmentQty->storeid = $request->store;


        event(new stockadjustment($adjustmentQty));

         //event(new stockadjustment());
        
        return redirect()->route("inventory.home",$productId);
    }


    public function History($productid){
        
        $this->user_validation();
        
        $product = Product::findorfail($productid);
        $category = Category::findorfail($product->category_id );
        $adjustments = DB::SELECT("SELECT a.applydate,
                                        a.type,
                                        a.quantity,
                                        b.Code unit
                                FROM    inv_adjustment a, units b WHERE a.unit = b.id and a.product= ?",[$productid]);


        return view('inventory.home.history',compact('product','category','adjustments'));
    }
}
