<?php

namespace App\Http\Controllers;

use App\Models\stores;
use App\Models\User;
use Illuminate\Http\Request;


class StoresController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $stores = stores::paginate(5);



        return view('stores.index',compact('stores'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $stores = stores::paginate(5);
        return view('stores.create',compact('stores'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
         $validate = $request->validate([
            'name' => 'required|min:3|regex:/^[a-zA-Z ]+$/',
            'address1' => 'required|min:3',
            'address2' => 'required|min:3',
            'address3' => 'required|min:3|',
        ]);


        stores::create($request->only(['name','address1','address2','address3','phone1','phone2']));

        return redirect()->route('stores.index');
    }

    /**
     * Display the specified resource.
     */
    public function show(Int $store_id)
    {

        $Store = stores::findorfail($store_id);
        $Store->delete();
        return redirect()->route('stores.index');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Int $store_id)
    {
        $Store = stores::findorfail($store_id);
        return view('stores.edit',compact('Store'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Int $store_id)
    {
        $Store = stores::findorfail($store_id);
        $Store->name = $request->name;
        $Store->address1 = $request->address1;
        $Store->address2 = $request->address2;
        $Store->address3 = $request->address3;
        $Store->phone1 = $request->phone1;
        $Store->phone2 = $request->phone2;
        $Store->update();
        return redirect()->route('stores.index');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Int $store_id)
    {
        $Store = stores::findorfail($store_id);
        $Store->delete();
        return redirect()->route('stores.index');
    }



    public function userstore(Int $userid){
        $stores = stores::paginate(5);
        return view('stores.userstore',compact('stores','userid'));
    }
    public function userstoreupdate(Int $storeid,Int $userid){
        $User = User::findorfail($userid);

        $User->store = $storeid;

        $User->update();

        return redirect()->route('users.index');
    }

}
