<?php

namespace App\Http\Controllers\RevExp;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;


use App\Models\glaccount;
use App\Models\Supplier;
use App\Models\RevExpTransaction;


use DB;

class Home extends Controller
{
    public function index(Int $id){
        //$glaccounts = glaccount::SELECT('idxx','category','glcode','code','Description')->WHERE('category',$id);
        $glaccounts = DB::table('glaccounts')
                        ->WHERE('category',$id)
                        ->get();
        return view('RevExp.index',compact('id'))->with('glaccounts',$glaccounts);
    }

    public function addaccount(Int  $id){
        return view('RevExp.addaccount',compact('id'));
    }

    public function gldetails(Int $id,Int $glCodeId){
        /* {{route('RevExp.assign',[$glaccount->id])}} */
            
            
            
        

        $glaccount = glaccount::findorfail($glCodeId);

        $revexptrans = DB::table('rev_exp_transactions')
                        ->SELECT('rev_exp_transactions.id','glaccounts.code','suppliers.name','rev_exp_transactions.applydate','rev_exp_transactions.amount','currency.Code')
                        ->JOIN('suppliers','suppliers.id','rev_exp_transactions.Supplier')
                        ->JOIN('glaccounts','glaccounts.id','rev_exp_transactions.glcode')
                        ->JOIN('currency','currency.ControlNum','rev_exp_transactions.CurCtrlNum')
                        ->WHERE('rev_exp_transactions.glcode',$glCodeId)
                        ->WHERE('PostStatus',0)
                        ->get();
        return view('RevExp.gldetails',compact('id','revexptrans','glaccount'));
    }
    public function store(Request $request, Int $id){
        $glaccount = new glaccount();
        $glaccount->category = $id;
        $glaccount->glcode = 0;
        $glaccount->code= $request->Description;
        $glaccount->Description = $request->Description;
        $glaccount->save();
        $glaccount->glcode =  $id.str_pad($glaccount->id,5,"0",STR_PAD_LEFT);
        $glaccount->update();
        return redirect()->route('RevExp.Home',[$id]);
    }
    public function assign(Int $id,Int $glCodeId){
       
        $currencies = DB::Table('currency')->SELECT('ControlNum','Code')->get();
        $Suppliers = Supplier::all();
        $glaccount =  glaccount::findorfail($glCodeId);
        return view('RevExp.assign',compact('id','glaccount','Suppliers','currencies'));
    }

    public function transaction(Request $request, Int $id,Int $glCodeId){
        
        $RevExpTransaction = new RevExpTransaction();
        $RevExpTransaction->glcode = $glCodeId;
        $RevExpTransaction->Supplier = $request->supplierId;
        $RevExpTransaction->applydate = $request->ApplyDate;
        $RevExpTransaction->RefNum = $request->ReferenceNum;
        $RevExpTransaction->amount = $request->Amount;
        $RevExpTransaction->CurCtrlNum = $request->currency;
        $RevExpTransaction->Notes = $request->Notes;
        $RevExpTransaction->save();
        return redirect()->route('RevExp.details',[$id,$glCodeId]);
    }
    
    
    public function Post_Transaction(Int $transactionId,Int $id){
        $RevExpTrans = RevExpTransaction::findorfail($transactionId);
        $RevExpTrans->PostStatus = 1;
        $RevExpTrans->update();
        return redirect()->route('RevExp.details',[$id,$RevExpTrans->glcode]);
        
    }
    
    public function view_transaction(Int $transactionId,Int $id){
        $RevExpTransaction = RevExpTransaction::findorfail($transactionId);
        
        
        //dd($RevExpTransaction);
        
        
        $currencies = DB::Table('currency')->SELECT('ControlNum','Code')->get();
        $Suppliers = Supplier::all();
        $SelectedSuppliers = Supplier::findorfail($RevExpTransaction->Supplier);
        $glaccount =  glaccount::findorfail($RevExpTransaction->id);
        return view('RevExp.View',compact('id','glaccount','Suppliers','currencies','RevExpTransaction','SelectedSuppliers'));            
    }
    
    public function update_transaction(Request $request,int $id,int $RevExpTransactionId){
        
        $RevExpTransaction = RevExpTransaction::findorfail($RevExpTransactionId);
        $RevExpTransaction->Supplier = $request->supplierId;
        $RevExpTransaction->applydate =  $request->ApplyDate;
        $RevExpTransaction->RefNum = $request->ReferenceNum;
        $RevExpTransaction->CurCtrlNum = $request->currency; 
        $RevExpTransaction->amount = $request->Amount;
        $RevExpTransaction->Notes = $request->Notes;
        
        $RevExpTransaction->update();
        return redirect()->route('RevExp.details',[$id,$RevExpTransaction->glcode]);

        
        
    }
}
