<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;

class dailysales extends Controller
{



    public function index(){
        return view('Reports.dailysales.index');
    }

    public function report(Request $request){


        $ReportParam = ['Start_Date' => $request->StartDate,'End_Date' => $request->EndDate];

        $StoreDailySales = DB::SELECT("SELECT    c.id, c.name, sum(b.quantity * b.price) Total 
                                    FROM    sales_item_hdrs a, sales_item_dets b, stores c 
                                    WHERE   a.OrderCtrlNum = b.OrderCtrlNum 
                                    AND     a.store = c.id  
                                    AND     STR_TO_DATE(a.applydate, '%Y-%m-%d') >= STR_TO_DATE(?, '%Y-%m-%d')
                                    AND     STR_TO_DATE(a.applydate, '%Y-%m-%d') <= STR_TO_DATE(?, '%Y-%m-%d')
                                    group by c.name,c.id",[$request->StartDate,$request->EndDate]);

   

        $dailySales = DB::SELECT("SELECT    DATE_FORMAT(a.applydate,'%d-%m-%Y') applydate,a.OrderCtrlNum,a.UserId,c.product_code,b.taxAmount,b.quantity,b.quantity,b.price,
                                            e.Code
                                    FROM    sales_item_hdrs a, sales_item_dets b, products c, units e
                                    WHERE   a.OrderCtrlNum = b.OrderCtrlNum
                                    AND     b.itemctrlnum = c.id
                                    AND     c.SellingUnit = e.id
                                    AND     STR_TO_DATE(a.applydate, '%Y-%m-%d') >= STR_TO_DATE(?, '%Y-%m-%d')
                                    AND     STR_TO_DATE(a.applydate, '%Y-%m-%d') <= STR_TO_DATE(?, '%Y-%m-%d')",[$request->StartDate,$request->EndDate]);
/*

                                    
                                    AND     a.created_at <= ?
*/
         return view('Reports.dailysales.report',compact('ReportParam'))->with('dailySales',$dailySales)->with('StoreDailySales',$StoreDailySales);
    }
    
    
 public function store_daily_report($Store,$StartDate,$EndDate){

     

        $ReportParam = [$StartDate,$EndDate];

        $userStoreDailySales = DB::SELECT("SELECT    d.name username, c.name, sum(b.quantity * b.price) Total 
                                    FROM    sales_item_hdrs a, sales_item_dets b, stores c ,users d
                                    WHERE   a.OrderCtrlNum = b.OrderCtrlNum 
                                    AND     a.Store = ?
                                    AND     a.store = c.id  
                                    AND     a.UserId = d.id
                                    AND     STR_TO_DATE(a.applydate, '%Y-%m-%d') >= STR_TO_DATE(?, '%Y-%m-%d')
                                    AND     STR_TO_DATE(a.applydate, '%Y-%m-%d') <= STR_TO_DATE(?, '%Y-%m-%d')
                                    group by d.name, c.name",[$Store,$StartDate,$EndDate]);

   

        $dailySales = DB::SELECT("SELECT    DATE_FORMAT(a.applydate,'%d-%m-%Y') applydate,a.OrderCtrlNum,a.UserId,c.product_code,b.taxAmount,b.quantity,b.quantity,b.price,
                                            e.Code
                                    FROM    sales_item_hdrs a, sales_item_dets b, products c, units e
                                    WHERE   a.OrderCtrlNum = b.OrderCtrlNum
                                    AND     a.Store = ?
                                    AND     b.itemctrlnum = c.id
                                    AND     c.SellingUnit = e.id
                                    AND     STR_TO_DATE(a.applydate, '%Y-%m-%d') >= STR_TO_DATE(?, '%Y-%m-%d')
                                    AND     STR_TO_DATE(a.applydate, '%Y-%m-%d') <= STR_TO_DATE(?, '%Y-%m-%d')",[$Store,$StartDate,$EndDate]);
                                    
                                    
                               //     dd($dailySales);
/*

                                    
                                    AND     a.created_at <= ?
*/
         return view('Reports.dailysales.storereport',compact('ReportParam'))->with('dailySales',$dailySales)->with('userStoreDailySales',$userStoreDailySales);
    }    
    

}
