<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use PDF;

class Stocklevels extends Controller
{

    public function productsList(){
        return $ItemStockLevels = DB::SELECT("select    a.product_code, 
                                                        a.product_name,
                                                        a.category_id, 
                                                        a.supplier_id, 
                                                        a.BuyingUnit, 
                                                        (SELECT c.Code FROM units c WHERE c.id = a.BuyingUnit) BuyingUnitCode , 
                                                        a.SellingUnit, 
                                                        (SELECT c.Code FROM units c WHERE c.id = a.SellingUnit) SellingUnitCode ,
                                                        a.factor, 
                                                        a.buying_price,
                                                        a.selling_price, 
                                                        a.barcode , 
                                                        a.tax_id, 
                                                        a.SalesStatus,
                                                        b.Quantity
                                        from    products a, 
                                                stocklevels b
                                        WHERE   a.id=b.ItemCtrlNum");
    }
    
    public function storeproductsList($StoreId){
        return $ItemStockLevels = DB::SELECT("select    a.product_code, 
                                                        a.product_name,
                                                        a.category_id, 
                                                        a.supplier_id, 
                                                        a.BuyingUnit, 
                                                        (SELECT c.Code FROM units c WHERE c.id = a.BuyingUnit) BuyingUnitCode , 
                                                        a.SellingUnit, 
                                                        (SELECT c.Code FROM units c WHERE c.id = a.SellingUnit) SellingUnitCode ,
                                                        a.factor, 
                                                        a.buying_price,
                                                        a.selling_price, 
                                                        a.barcode , 
                                                        a.tax_id, 
                                                        a.SalesStatus,
                                                        b.Quantity
                                        from    products a, 
                                                storestocklevels b
                                        WHERE   a.id=b.ItemCtrlNum
                                        AND     b.StoreCtrlNum = ? ",[$StoreId]);
    }    
    
    
    
    
    public function index(){
        $ItemStockLevels = $this->productsList();
        return view('Reports.Stocklevels.index')->with('ItemStockLevels',$ItemStockLevels);
    }

    public function pdf(){
        $ItemStockLevels = $this->productsList();


        $data = ['title' => 'domPDF in Laravel 10'];
        $pdf = PDF::loadView('Reports.Stocklevels.pdf',compact('ItemStockLevels'));

        return $pdf->stream('itsolutionstuff.pdf');


    }
    
    
    
    
    public function storeindex(){
        $StoreLists = DB::SELECT("SELECT * FROM stores");
        
        $ItemStockLevels = $this->productsList();
        return view('Reports.StoreStockLevel.index', compact('StoreLists'))->with('ItemStockLevels',$ItemStockLevels);
    }
    
    
 
     public function LoadReport(Request $request){
        
        //$ItemStockLevels = 
        $StoreLists = DB::SELECT("SELECT * FROM stores");
        $ItemStockLevels = $this->storeproductsList($request->store);
        return view('Reports.StoreStockLevel.report', compact('StoreLists'))->with('ItemStockLevels',$ItemStockLevels)
                                                                            ->with('Store',$request->store);
    }
 
    
    
}



