<?php

namespace App\Http\Controllers\Purchases;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PO_Header;
use App\Models\PO_Detail;

use App\Models\receivedOrder;


use App\Events\receiveorderitem;


use DB;

class poReceive extends Controller
{

    public function index(){
            if (auth()->user()->store <= 0){
                return view('sales.error');
            }
            $orderSuppliers = DB::SELECT("select    ControlNum,name
                                            from    suppliers a,
                                                    PO_headers b
                                            WHERE   a.id = b.Supplier
                                            AND     b.ControlNum IN (select DISTINCT d.HeaderCtrlNum from req_order_track d, po_store_item_qty e WHERE d.HeaderCtrlNum = e.POCtrlNum AND d.ProductCtrlNum= e.ItemCtrlNum AND e.Store = ?)",[auth()->user()->store]);
        return view('purchase.receive.index')->with('orderSuppliers',$orderSuppliers);
    }

    public function ItemsLists(string $POCtrlNum){


            if (auth()->user()->store <= 0){
                return view('sales.error');
            }
        
        $itemLists = DB::SELECT("SELECT c.product_name,
                                        d.name,
                                        f.quantity Qty,
                                        b.HeaderCtrlNum,
                                        b.ProductCtrlNum,
                                        (SELECT sum(e.QtyReceived) FROM PO_receives e WHERE b.HeaderCtrlNum = e.PurchaseCtrlNum and e.Item = c.id AND e.store = ?) ReceivedQty
                                 FROM   PO_headers a,
                                        PO_details b,
                                        products   c,
                                        categories   d,
                                        po_store_item_qty f
                                WHERE   a.ControlNum = b.HeaderCtrlNum
                                AND     b.ProductCtrlNum = c.id
                                AND     d.id = c.category_id

                                AND     b.HeaderCtrlNum = f.POCtrlNum
                                AND     b.ProductCtrlNum = f.ItemCtrlNum



                                AND     a.ControlNum = ? AND f.store  = ?",[auth()->user()->store,$POCtrlNum,auth()->user()->store]);




        return view('purchase.receive.itemLists',compact('POCtrlNum'))->with('itemLists',$itemLists);
    }

    public function Item(String $POCtrlNum, Int $Item){
    /*
        $item = DB::SELECT("SELECT *
                                 FROM   PO_headers a,
                                        PO_details b,
                                        products   c,
                                        categories   d
                                        req_order_track e
                                WHERE   a.ControlNum = b.HeaderCtrlNum
                                AND     b.ProductCtrlNum = c.id
                                AND     d.id = c.category_id
                                AND     a.ControlNum = ?",[$POCtrlNum]);
                                */

            if (auth()->user()->store <= 0){
                return view('sales.error');
            }                               
            /*
        $item = PO_Header::SELECT('*')
                        ->JOIN('PO_details','PO_details.HeaderCtrlNum','PO_headers.ControlNum')
                        ->JOIN('products','products.id','PO_details.ProductCtrlNum')
                        ->JOIN('categories','products.category_id','categories.id')
                        ->WHERE('PO_headers.ControlNum',$POCtrlNum)
                        ->WHERE('products.id',$Item)->first();
                        
              */          
        $item = PO_Header::SELECT('*')
                        ->JOIN('po_store_item_qty','po_store_item_qty.POCtrlNum','PO_headers.ControlNum')
                        ->JOIN('products','products.id','po_store_item_qty.ItemCtrlNum')
                        ->JOIN('categories','products.category_id','categories.id')
                        ->WHERE('PO_headers.ControlNum',$POCtrlNum)
                        ->WHERE('po_store_item_qty.Store',auth()->user()->store)
                        ->WHERE('products.id',$Item)->first();                        
                        

        return view('purchase.receive.create',compact('POCtrlNum','Item'))->with('item',$item);
    }


    public function Save(Request $request, String $POCtrlNum, String $Item){


            if (auth()->user()->store <= 0){
                return view('sales.error');
            }
        $receivedOrder = new receivedOrder();

        $receivedOrder->OrderCtrlNum = $POCtrlNum;
        $receivedOrder->ItemCtrlNum  = $Item;
        $receivedOrder->ApplyDate = $request->ApplyDate;
        $receivedOrder->Quantity  = $request->Quantity;
        $receivedOrder->ReceivedQty = $request->ReceivedQty;

        event(new receiveorderitem($receivedOrder));

        return redirect()->route('purchase.receive.ItemsLists',$POCtrlNum);
    }
}
