<?php

namespace App\Http\Controllers\Payment;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;


use App\Models\Supplier;
use App\Models\PMode;
use App\Models\tempPaymentHeader;
use App\Models\temppaymentsdet;

use App\Models\PaymentsHdr;

use App\Models\PaymentsDet;


use App\Models\PoOutstandingPay;

use DB;
use PDF;

class outGoing extends Controller
{
    public function index(){
        $outstandingPays = DB::SELECT('select   a.id,
                                                a.SupplierId,
                                                b.name,
                                                c.Code PMode,
                                                d.Code Currency,
                                                a.Reference,
                                                a.ApplyDate,
                                                a.Amount
                                        from    temp_payments_hdrs a,
                                                suppliers b,
                                                p_modes c,
                                                currency d
                                        WHERE   a.SupplierId=b.id   AND a.PMode=c.id AND a.Currency = d.ControlNum');
        //dd($outstandingPays );
        return view('payments.outgoing.index',compact('outstandingPays'));
    }
    public function suppliers(){
        $outstandingPays = DB::SELECT('select   DiSTINCT 
                                                a.Supplier,
                                                b.name,
                                                a.Currency
                                        from    PO_headers a,
                                                suppliers b
                                        WHERE   a.Supplier=b.id AND     a.ControlNum IN (SELECT ControlNum FROM po_outstanding_pays)');
        return view('payments.outgoing.suppliers',compact('outstandingPays'));
    }

    public function SupplierPOList(Int $SupplierCtrlNum){

        $outstandingPays = DB::SELECT('select   a.ControlNum,
                                                a.Supplier,
                                                b.name,
                                                a.Currency
                                        from    PO_headers a,
                                                suppliers b
                                        WHERE   a.Supplier=b.id

                                        ');
            $PModes = PMode::all();
            $supplier = Supplier::SELECT('*')->WHERE('id',$SupplierCtrlNum)->first();
        return view('payments.outgoing.header',compact('supplier','PModes'));
    }




    public function headerSave(Request $request){


        $tempPaymentHeader = new tempPaymentHeader();

        $tempPaymentHeader->SupplierId = $request->supplierId;
        $tempPaymentHeader->PMode = $request->PMode;
        $tempPaymentHeader->ApplyDate = $request->applyDate;
        $tempPaymentHeader->Amount =  $request->Amount;
        $tempPaymentHeader->UserId = 0 ;
        $tempPaymentHeader->Currency =  $request->Currency;
        $tempPaymentHeader->Reference =  $request->ReferenceNum;



        //dd('Test');


        $tempPaymentHeader->save();

        return redirect()->route('payment.outgoing.outstanding',[$tempPaymentHeader->id]);

    }



    public function outstandingPOList(Int $HeaderCtrlNum){
            $header = tempPaymentHeader::findorfail($HeaderCtrlNum);
            //dd($header);
            $Supplier = Supplier::findorfail($header->SupplierId);
            /*
            $outstandingPays = DB::SELECT("
                    SELECT  a.ControlNum,  a.Currency, b.TaxCtrlNum, b.TaxQty, b.ProductCtrlNum, sum(b.Qty * b.ItemAmt) ItemTotal
                    FROM    PO_headers a, PO_details b
                    WHERE   a.ControlNum = b.HeaderCtrlNum
                    AND     a.Supplier = ?

            ",[$request->supplierId]);
            */
            /*
            $outstandingPays = DB::SELECT("SELECT   a.ControlNum, c.id, sum(b.Qty * b.ItemAmt) ItemTotal, c.amount
                                            FROM    PO_headers a
                                            INNER JOIN PO_details b ON  a.ControlNum = b.HeaderCtrlNum
                                            LEFT OUTER JOIN payment_dets e ON b.HeaderCtrlNum = e.TrxctrlNum
                                            LEFT OUTER JOIN temp_payments_dets c ON a.ControlNum = c.POCtrlNum
                                            WHERE     a.Supplier = ?
                                            GROUP BY  a.ControlNum, c.amount,c.id
                                            HAVING    sum(b.Qty * b.ItemAmt) -  sum(e.Amount) > 0 ",[$header->SupplierId]);

*/
                $outstandingPays = DB::SELECT("SELECT   a.ControlNum, c.id, (b.PurAmount - b.PayAmount) ItemTotal,  c.amount
                                            FROM    PO_headers a
                                            INNER JOIN po_outstanding_pays b ON  a.ControlNum = b.ControlNum
                                            LEFT OUTER JOIN temp_payments_dets c ON a.ControlNum = c.POCtrlNum
                                            WHERE     a.Supplier = ?",[$header->SupplierId]);


            return view('payments.outgoing.outstanding',compact('header','Supplier','outstandingPays' ));
    }

    public function outstandingPOPay($HeaderCtrlNum,$POCtrlNum, $Amount){


          // $sumAmount = DB::SELECT('SELECT sum(amount) Amount FROM temp_payments_dets');
            $sum = tempPaymentHeader::SELECT( 'sum(temp_payments_dets.amountxx)')
                    ->join('temp_payments_dets','temp_payments_hdrs.id', 'temp_payments_dets.HeaderCtrlNum');
            //dd($sum );

            $PO_Header_Total = tempPaymentHeader::WHERE('id',$HeaderCtrlNum)->sum('Amount');
            //dd($PO_Header_Total);
            $PO_Detail_Total = temppaymentsdet::WHERE('HeaderCtrlNum',$HeaderCtrlNum)->sum('amount');

            /******* GETTING BALANCE OF CASH SAVES AND AMOUNT PAYED *****/

            $sumDiff = tempPaymentHeader::WHERE('id',$HeaderCtrlNum)->sum('Amount')  - temppaymentsdet::WHERE('HeaderCtrlNum',$HeaderCtrlNum)->sum('amount');



            if ($sumDiff >= $Amount ){
                DB::INSERT('INSERT INTO temp_payments_dets (HeaderCtrlNum,POCtrlNum,amount) VALUES (?,?,?)',[$HeaderCtrlNum,$POCtrlNum, $Amount]);
            } else if($sumDiff > 0) {
                DB::INSERT('INSERT INTO temp_payments_dets (HeaderCtrlNum,POCtrlNum,amount) VALUES (?,?,?)',[$HeaderCtrlNum,$POCtrlNum, $sumDiff]);
            }


           //DB::INSERT('INSERT INTO temp_payments_dets (HeaderCtrlNum,POCtrlNum,amount) VALUES (?,?,?)',[$HeaderCtrlNum,$POCtrlNum, $Amount]);
           return redirect()->route('payment.outgoing.outstanding',[$HeaderCtrlNum]);
    }

    public function outstandingPOPayDel($id){





        $temppaymentsdet = temppaymentsdet::findorfail($id);

        $temppaymentsdet->delete();

        return redirect()->route('payment.outgoing.outstanding',[$temppaymentsdet->HeaderCtrlNum]);
    }



    public function PaymentComplete($ControlNum){



            $PaymentsHdr = new PaymentsHdr();

            $tempPaymentHeader = tempPaymentHeader::findorfail($ControlNum);



            $PaymentsHdr->SupplierCtrlNum = $tempPaymentHeader->SupplierId;
            $PaymentsHdr->CurrencyCtrlNum = $tempPaymentHeader->PMode;
            $PaymentsHdr->PMode = $tempPaymentHeader->PMode;
            $PaymentsHdr->Reference = $tempPaymentHeader->Reference;
            $PaymentsHdr->ApplyDate = $tempPaymentHeader->ApplyDate;
            $PaymentsHdr->Status = 0;
            $PaymentsHdr->PaidAmount = $tempPaymentHeader->Amount;

            //dd($PaymentsHdr);

            if($PaymentsHdr->save()){

                DB::SELECT('INSERT INTO payment_dets(HeaderCtrlNum,TrxctrlNum,Amount)
                            SELECT  ?,POCtrlNum, Amount
                            FROM    temp_payments_dets
                            WHERE   HeaderCtrlNum = ? ',[$PaymentsHdr->id,$ControlNum,]);

                $payments = DB::SELECT("SELECT * FROM payment_dets WHERE payment_dets.HeaderCtrlNum = ? ",[$PaymentsHdr->id]);

                //dd($payments);



                foreach($payments as $payment){

                    $PoOutstandingPay = PoOutstandingPay::WHERE('ControlNum',$payment->TrxctrlNum)->first();


                    $PoOutstandingPay->PayAmount = $PoOutstandingPay->PayAmount + $payment->Amount;

                    $PoOutstandingPay->update();


                }


                DB::SELECT('DELETE FROM temp_payments_hdrs WHERE id=?',[$ControlNum]);
                DB::SELECT('DELETE FROM temp_payments_dets WHERE HeaderCtrlNum=?',[$ControlNum]);
                DB::SELECT('DELETE FROM po_outstanding_pays WHERE PurAmount <= PayAmount');

                return redirect()->route('payment.outgoing.receipt',[$PaymentsHdr->id]);
                //dd('Test');
            }



        return redirect()->route('payment.outgoing.index');
    }

    public function Paymentdelete($id){
        DB::SELECT('DELETE FROM temp_payments_hdrs WHERE id=?',[$id]);
        DB::SELECT('DELETE FROM temp_payments_dets WHERE HeaderCtrlNum=?',[$id]);

        return redirect()->route('payment.outgoing.index');
    }


    public function Paymentreceipt($id){
        $PaymentsHdrs = PaymentsHdr::findorfail($id);
        $Supplier = Supplier::findorfail($PaymentsHdrs->SupplierCtrlNum);
        //dd($Supplier);
        $PaymentsDets = DB::SELECT("select * from payment_dets WHERE HeaderCtrlNum = ? ",[$id]);
        return view('payments.outgoing.report',compact('PaymentsHdrs','PaymentsDets','Supplier','id'));
    }

    public function pdf($id){

        $PaymentsHdrs = PaymentsHdr::findorfail($id);
        $Supplier = Supplier::findorfail($PaymentsHdrs->SupplierCtrlNum);
        //dd($Supplier);
        $PaymentsDets = DB::SELECT("select * from payment_dets WHERE HeaderCtrlNum = ? ",[$id]);
        $pdf = PDF::loadView('payments.outgoing.pdf',compact('PaymentsHdrs','PaymentsDets','Supplier','id'));
        return $pdf->stream('itsolutionstuff.pdf');
    }



}
