<?php

namespace App\Http\Controllers;

use App\Models\maincategory;
use Illuminate\Http\Request;

use App\Models\Category;


class MaincategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
            $row = (int) request('row', 10);

        if ($row < 1 || $row > 100) {
            abort(400, 'The per-page parameter must be an integer between 1 and 100.');
        }

        return view('maincategory.index', [
            'categories' => maincategory::filter(request(['search']))
                ->sortable()
                ->paginate($row)
                ->appends(request()->query()),
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('maincategory.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //dd($request);
            $maincategory = new maincategory();
            $maincategory->Code = $request->Code;
            $maincategory->Description = $request->Description;
            $maincategory->save();
        return redirect()->route('categories.index');
    }

    /**
     * Display the specified resource.
     */
    public function show(maincategory $maincategory)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(maincategory $maincategory)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, maincategory $maincategory)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Int $maincategory)
    {
        $mainCategory =  maincategory::findorfail($maincategory);
        $mainCategory->delete();
        return redirect()->route('categories.index');
    }
}
