@extends('dashboard.body.main')

@section('container')

        <div class="col-lg-12">
            @if (session()->has('success'))
                <div class="alert text-white bg-success" role="alert">
                    <div class="iq-alert-text">{{ session('success') }}</div>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="ri-close-line"></i>
                    </button>
                </div>
            @endif
            <div class="d-flex flex-wrap align-items-center justify-content-between mb-4">
                <div>
                    <h4 class="mb-3">Supplier List</h4>
                    <!--
                    <p class="mb-0">A supplier dashboard lets you easily gather and visualize supplier data from optimizing <br>
                        the supplier experience, ensuring supplier retention. </p>
                    -->
                </div>
                <div>
                    <a href="{{ route('payment.outgoing.suppliers') }}" class="btn add-list"><i class="fa-solid fa-plus mr-3"></i>Add Payments</a>
                    <!-- <a href="{{ route('order.index') }}" class="btn btn-danger add-list"><i class="fa-solid fa-trash mr-3"></i>Clear Search</a> -->
                </div>
            </div>
        </div>

        <div class="row">
            <table class="table">
                @foreach($outstandingPays as $outstandingPay)
                    <tr>
                        <td>{{$outstandingPay->name}}</td>
                        <td>{{$outstandingPay->PMode}}</td>
                        <td>{{$outstandingPay->Currency}}</td>
                        <td>{{$outstandingPay->Reference}}</td>
                        <td>{{$outstandingPay->ApplyDate}}</td>
                        <td>{{$outstandingPay->Amount}}</td>
                        <td>
                            <form method="POST" action="{{route('payment.outgoing.delete',[$outstandingPay->id])}}">
                                @csrf
                                <button class="btn" type="submit"><i class="ri-delete-bin-line mr-0"></i></botton>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </table>
            </div>




@endsection
